<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/database.php';

echo "<h2>Updating Product Images</h2>";

// Product image mappings
$productImages = [
    1 => 'Daily Pooja Kit.webp',           // Daily Pooja Kit
    2 => 'Ganesh Pooja Kit.jpg',           // Ganesh Pooja Kit
    3 => 'Satyanarayan Kit.jpg',           // Satyanarayan Kit
    4 => 'Lakshmi Pooja Kit.jpg',          // Lakshmi Pooja Kit
    5 => 'Navratri Special Kit.jpg',       // Navratri Special Kit
    6 => 'Shiv Pooja Kit.jpg',             // Shiv Pooja Kit
    7 => 'Hanuman Pooja Kit.webp',         // Hanuman Pooja Kit
    8 => 'SampoornaDurgaPoojaKit01.jpg',   // Durga Pooja Kit
    9 => 'Krishna Pooja Kit.jpg',          // Krishna Pooja Kit
    10 => 'Saraswati Pooja Kit.jpg',       // Saraswati Pooja Kit
    11 => 'Griha Pravesh Kit.jpg',         // Griha Pravesh Kit
    12 => 'Rudrabhishek Kit.webp',         // Rudrabhishek Kit
    13 => 'Sunderkand Path Kit.jpg',       // Sunderkand Path Kit
    14 => 'Ganpati Homam Kit.jpg',         // Ganpati Homam Kit
    15 => 'Satyanarayan Swamy Kit.jpg'     // Satyanarayan Swamy Kit
];

$conn = connectDB();
if (!$conn) {
    echo "<p style='color: red;'>✗ Database connection failed</p>";
    exit;
}

echo "<p style='color: green;'>✓ Database connected successfully</p>";

$successCount = 0;
$errorCount = 0;

foreach ($productImages as $productId => $imageUrl) {
    $productId = (int)$productId;
    $imageUrl = $conn->real_escape_string($imageUrl);
    
    $query = "UPDATE products SET image_url = '$imageUrl' WHERE id = $productId";
    
    if ($conn->query($query)) {
        if ($conn->affected_rows > 0) {
            echo "<p style='color: green;'>✓ Updated product ID $productId with image: $imageUrl</p>";
            $successCount++;
        } else {
            echo "<p style='color: orange;'>⚠ No changes for product ID $productId</p>";
        }
    } else {
        echo "<p style='color: red;'>✗ Error updating product ID $productId: " . $conn->error . "</p>";
        $errorCount++;
    }
}

closeDB($conn);

echo "<h3>Summary</h3>";
echo "<p>Successfully updated: $successCount products</p>";
echo "<p>Errors: $errorCount</p>";

// Test the updates
echo "<h3>Testing Updated Products</h3>";
require_once __DIR__ . '/classes/Product.php';

for ($i = 1; $i <= 5; $i++) {
    $product = Product::getProductById($i);
    if ($product) {
        echo "<p>Product $i: " . $product['name'] . " - Image: " . ($product['image_url'] ?? 'No image') . "</p>";
    }
}
?> 