<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Cart Fix Test</h2>";

// Start session
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Test cart functionality
require_once __DIR__ . '/classes/Cart.php';
require_once __DIR__ . '/classes/Product.php';

try {
    $cart = new Cart();
    echo "<p style='color: green;'>✓ Cart class loaded successfully</p>";
    
    // Test adding a product
    $success = $cart->addItem(1, 2);
    
    if ($success) {
        echo "<p style='color: green;'>✓ Product added to cart successfully</p>";
        echo "<p>Cart items: " . count($cart->getItems()) . "</p>";
        echo "<p>Cart total: ₹" . $cart->getTotal() . "</p>";
        echo "<p>Cart count: " . $cart->getItemCount() . "</p>";
        
        echo "<h3>Cart Contents:</h3>";
        echo "<pre>" . print_r($cart->getItems(), true) . "</pre>";
    } else {
        echo "<p style='color: red;'>✗ Failed to add product to cart</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Error: " . $e->getMessage() . "</p>";
}

// Test cart-actions.php
echo "<h3>Testing cart-actions.php</h3>";
echo "<form method='post' action='cart-actions.php'>";
echo "<input type='hidden' name='action' value='add'>";
echo "<input type='hidden' name='product_id' value='1'>";
echo "<input type='hidden' name='quantity' value='1'>";
echo "<button type='submit'>Test Add to Cart via cart-actions.php</button>";
echo "</form>";

if ($_POST) {
    echo "<h4>Form submitted successfully!</h4>";
}
?> 