<?php
require_once 'config/config.php';
require_once 'config/database.php';
require_once 'classes/Product.php';

// Initialize database connection
$db = connectDB();
if (!$db) {
    die('Database connection failed');
}

// Get product ID from URL
$product_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Create Product instance
$productObj = new Product();

// Get product details
$product = Product::getProductById($product_id);
if (!$product) {
    header('Location: shop.php');
    exit;
}

// Get product materials
$materials = Product::getProductMaterials($product_id);

// Get product reviews
$reviews = Product::getProductReviews($product_id);
$averageRating = Product::getAverageRating($product_id);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($product['name']); ?> - PoojaFestival.in</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light bg-light">
        <div class="container">
            <a class="navbar-brand" href="index.php">PoojaFestival.in</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="shop.php">Shop</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="custom-kit.php">Custom Kit Builder</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Product Details -->
    <div class="container py-5">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                <li class="breadcrumb-item"><a href="shop.php">Shop</a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo htmlspecialchars($product['name']); ?></li>
            </ol>
        </nav>

        <div class="row g-5">
            <!-- Product Image -->
            <div class="col-md-6">
                <div class="product-image-container">
                    <img src="./assets/images/<?php echo htmlspecialchars($product['image_url']); ?>" 
                         class="img-fluid rounded" 
                         alt="<?php echo htmlspecialchars($product['name']); ?>">
                    <?php if ($product['sale_price'] || $product['is_featured']): ?>
                    <div class="product-badges">
                        <?php if ($product['sale_price']): ?>
                            <span class="badge bg-danger">Sale</span>
                        <?php endif; ?>
                        <?php if ($product['is_featured']): ?>
                            <span class="badge bg-primary">Featured</span>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Product Info -->
            <div class="col-md-6">
                <h1 class="mb-4"><?php echo htmlspecialchars($product['name']); ?></h1>
                
                <div class="mb-4">
                    <div class="d-flex align-items-center mb-2">
                        <div class="ratings me-2">
                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                <i class="bi bi-star<?php echo $i <= $averageRating ? '-fill' : ''; ?> text-warning"></i>
                            <?php endfor; ?>
                        </div>
                        <span class="text-muted">(<?php echo count($reviews); ?> reviews)</span>
                    </div>
                    
                    <div class="product-price">
                        <?php if ($product['sale_price']): ?>
                            <span class="text-decoration-line-through text-muted fs-5">₹<?php echo number_format($product['price'], 2); ?></span>
                            <span class="text-danger fs-3 ms-2">₹<?php echo number_format($product['sale_price'], 2); ?></span>
                        <?php else: ?>
                            <span class="text-primary fs-3">₹<?php echo number_format($product['price'], 2); ?></span>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="mb-4">
                    <h5>Description</h5>
                    <p><?php echo nl2br(htmlspecialchars($product['description'])); ?></p>
                </div>

                <?php if (!empty($materials)): ?>
                <div class="mb-4">
                    <h5>Kit Contents</h5>
                    <ul class="list-group">
                        <?php foreach ($materials as $material): ?>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <?php echo htmlspecialchars($material['name']); ?>
                            <span class="badge bg-primary rounded-pill"><?php echo htmlspecialchars($material['quantity']); ?></span>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

                <div class="d-grid gap-2">
                    <button class="btn btn-primary btn-lg" onclick="addToCart(<?php echo $product['id']; ?>)">
                        <i class="bi bi-cart-plus me-2"></i>Add to Cart
                    </button>
                    <button class="btn btn-outline-primary btn-lg" onclick="addToCustomKit(<?php echo $product['id']; ?>)">
                        <i class="bi bi-plus-circle me-2"></i>Add to Custom Kit
                    </button>
                </div>
            </div>
        </div>

        <!-- Reviews Section -->
        <?php if (!empty($reviews)): ?>
        <div class="row mt-5">
            <div class="col-12">
                <h3 class="mb-4">Customer Reviews</h3>
                <div class="reviews-container">
                    <?php foreach ($reviews as $review): ?>
                    <div class="card mb-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between mb-2">
                                <div>
                                    <h6 class="mb-0"><?php echo htmlspecialchars($review['user_name']); ?></h6>
                                    <div class="ratings">
                                        <?php for ($i = 1; $i <= 5; $i++): ?>
                                            <i class="bi bi-star<?php echo $i <= $review['rating'] ? '-fill' : ''; ?> text-warning"></i>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                                <small class="text-muted"><?php echo date('M d, Y', strtotime($review['created_at'])); ?></small>
                            </div>
                            <p class="card-text"><?php echo nl2br(htmlspecialchars($review['comment'])); ?></p>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/main.js"></script>
    <script>
    function addToCart(productId) {
        // TODO: Implement cart functionality
        alert('Product added to cart!');
    }

    function addToCustomKit(productId) {
        // TODO: Implement custom kit functionality
        alert('Product added to custom kit!');
    }
    </script>
</body>
</html>