<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/classes/Order.php';

// Start session
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Check if order ID is provided
if (!isset($_GET['order_id'])) {
    header('Location: index.php');
    exit;
}

$orderId = (int)$_GET['order_id'];
$order = Order::getOrderWithItems($orderId);

if (!$order) {
    header('Location: index.php');
    exit;
}

// Verify order belongs to user (if logged in)
if (isset($_SESSION['user_id'])) {
    if (!Order::validateOrderOwnership($orderId, $_SESSION['user_id'])) {
        header('Location: index.php');
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Successful - PoojaFestival.in</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <!-- Navigation -->
    <?php include 'includes/nav.php'; ?>

    <div class="container my-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card border-success">
                    <div class="card-body text-center">
                        <div class="mb-4">
                            <i class="bi bi-check-circle text-success" style="font-size: 5rem;"></i>
                        </div>
                        
                        <h2 class="text-success mb-3">Payment Successful!</h2>
                        <p class="lead mb-4">Thank you for your purchase. Your order has been confirmed.</p>
                        
                        <div class="alert alert-success">
                            <h5>Order Details</h5>
                            <p><strong>Order ID:</strong> #<?php echo $orderId; ?></p>
                            <p><strong>Total Amount:</strong> ₹<?php echo number_format($order['total_amount'], 2); ?></p>
                            <p><strong>Payment Status:</strong> <span class="badge bg-success">Paid</span></p>
                            <p><strong>Order Status:</strong> <span class="badge bg-primary">Processing</span></p>
                        </div>
                        
                        <div class="row mt-4">
                            <div class="col-md-6">
                                <h6>Shipping Address</h6>
                                <?php 
                                $address = json_decode($order['shipping_address'], true);
                                if ($address): 
                                ?>
                                <div class="text-start">
                                    <p class="mb-1"><strong><?php echo htmlspecialchars($address['name']); ?></strong></p>
                                    <p class="mb-1"><?php echo htmlspecialchars($address['address']); ?></p>
                                    <p class="mb-1"><?php echo htmlspecialchars($address['city'] . ', ' . $address['state'] . ' - ' . $address['pincode']); ?></p>
                                    <p class="mb-1">Phone: <?php echo htmlspecialchars($address['phone']); ?></p>
                                    <p class="mb-0">Email: <?php echo htmlspecialchars($address['email']); ?></p>
                                </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="col-md-6">
                                <h6>Order Items</h6>
                                <div class="text-start">
                                    <?php foreach ($order['items'] as $item): ?>
                                    <div class="d-flex justify-content-between mb-1">
                                        <span><?php echo htmlspecialchars($item['name']); ?> (Qty: <?php echo $item['quantity']; ?>)</span>
                                        <span>₹<?php echo number_format($item['price'] * $item['quantity'], 2); ?></span>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mt-4">
                            <p class="text-muted">
                                <i class="bi bi-envelope"></i> 
                                A confirmation email has been sent to <?php echo htmlspecialchars($address['email'] ?? ''); ?>
                            </p>
                            <p class="text-muted">
                                <i class="bi bi-truck"></i> 
                                Your order will be shipped within 2-3 business days
                            </p>
                        </div>
                        
                        <div class="d-grid gap-2 d-md-flex justify-content-md-center mt-4">
                            <a href="orders.php" class="btn btn-primary">
                                <i class="bi bi-list-ul"></i> View My Orders
                            </a>
                            <a href="shop.php" class="btn btn-outline-primary">
                                <i class="bi bi-shop"></i> Continue Shopping
                            </a>
                        </div>
                    </div>
                </div>
                
                <!-- Additional Information -->
                <div class="card mt-4">
                    <div class="card-body">
                        <h5><i class="bi bi-info-circle"></i> What's Next?</h5>
                        <div class="row">
                            <div class="col-md-4 text-center">
                                <i class="bi bi-gear text-primary" style="font-size: 2rem;"></i>
                                <h6 class="mt-2">Order Processing</h6>
                                <p class="text-muted small">We're preparing your order for shipment</p>
                            </div>
                            <div class="col-md-4 text-center">
                                <i class="bi bi-truck text-info" style="font-size: 2rem;"></i>
                                <h6 class="mt-2">Shipping</h6>
                                <p class="text-muted small">Your order will be shipped within 2-3 days</p>
                            </div>
                            <div class="col-md-4 text-center">
                                <i class="bi bi-house text-success" style="font-size: 2rem;"></i>
                                <h6 class="mt-2">Delivery</h6>
                                <p class="text-muted small">You'll receive your order at your doorstep</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script src="assets/js/cart.js"></script>
    
    <script>
        // Clear cart count since order is completed
        $(document).ready(function() {
            if (typeof ShoppingCart !== 'undefined') {
                ShoppingCart.updateCartCount(0);
            }
        });
    </script>
</body>
</html> 