<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>All Orders - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container py-5">
    <h1 class="mb-4">All Orders</h1>
    <div id="ordersTable"></div>
</div>
<script>
function fetchOrders() {
    fetch('api/get_all_orders.php')
        .then(res => res.json())
        .then(data => renderOrders(data));
}

function renderOrders(orders) {
    let html = `<table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>Order ID</th>
                <th>User</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Address</th>
                <th>Status</th>
                <th>Payment</th>
                <th>Items</th>
                <th>Total</th>
                <th>Update Status</th>
            </tr>
        </thead>
        <tbody>`;
    orders.forEach(order => {
        html += `<tr>
            <td>${order.id}</td>
            <td>${order.user_name}</td>
            <td>${order.email}</td>
            <td>${order.phone}</td>
            <td>${order.address}</td>
            <td><span id="status-${order.id}">${order.status}</span></td>
            <td>${order.payment_status}</td>
            <td><ul>` + order.items.map(item => {
                let itemHtml = `<li>${item.name} x${item.quantity} (₹${item.price})`;
                if (item.name.toLowerCase() === 'custom pooja kit' && order.custom_kit_materials && order.custom_kit_materials.length) {
                    itemHtml += '<ul>' + order.custom_kit_materials.map(mat => `<li>${mat.name}${mat.quantity ? ' (' + mat.quantity + ')' : ''}${mat.price ? ' (₹' + mat.price + ')' : ''}</li>`).join('') + '</ul>';
                }
                itemHtml += '</li>';
                return itemHtml;
            }).join('') + `</ul></td>
            <td>₹${order.total_amount}</td>
            <td>
                <select class="form-select form-select-sm d-inline w-auto" id="select-status-${order.id}">
                    <option value="pending" ${order.status==='pending'?'selected':''}>Pending</option>
                    <option value="processing" ${order.status==='processing'?'selected':''}>Processing</option>
                    <option value="shipped" ${order.status==='shipped'?'selected':''}>Shipped</option>
                    <option value="delivered" ${order.status==='delivered'?'selected':''}>Delivered</option>
                    <option value="cancelled" ${order.status==='cancelled'?'selected':''}>Cancelled</option>
                </select>
                <button class="btn btn-sm btn-primary mt-1" onclick="updateStatus(${order.id})">Update</button>
            </td>
        </tr>`;
    });
    html += '</tbody></table>';
    document.getElementById('ordersTable').innerHTML = html;
}

function updateStatus(orderId) {
    const select = document.getElementById('select-status-' + orderId);
    const newStatus = select.value;
    fetch('api/update_order_status.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ order_id: orderId, status: newStatus })
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            document.getElementById('status-' + orderId).textContent = newStatus;
            alert('Order status updated!');
        } else {
            alert('Failed to update status: ' + (data.error || 'Unknown error'));
        }
    });
}

document.addEventListener('DOMContentLoaded', fetchOrders);
</script>
</body>
</html> 