<?php
require_once 'config/database.php';

// Get Deity Specific category ID
$catQuery = "SELECT id FROM categories WHERE slug = 'deity-specific' LIMIT 1";
$cat = getRow($catQuery);
$cat_id = $cat ? (int)$cat['id'] : 0;

$products = [];
if ($cat_id) {
    $products = getRows("SELECT * FROM products WHERE category_id = $cat_id");
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Shop By Deity</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<?php include 'includes/nav.php'; ?>
<div class="container py-5">
    <h1 class="mb-4">Shop By Deity</h1>
    <div class="row">
        <?php if ($products && count($products)): foreach ($products as $product): ?>
            <div class="col-md-4 mb-4">
                <div class="card h-100">
                    <?php if ($product['image_url']): ?>
                        <img src="assets/images/<?= htmlspecialchars($product['image_url']) ?>" class="card-img-top" alt="<?= htmlspecialchars($product['name']) ?>">
                    <?php endif; ?>
                    <div class="card-body">
                        <h5 class="card-title"><?= htmlspecialchars($product['name']) ?></h5>
                        <p class="card-text">₹<?= number_format($product['price'], 2) ?></p>
                        <a href="product.php?slug=<?= urlencode($product['slug']) ?>" class="btn btn-primary me-2">View</a>
                        <input type="number" class="form-control d-inline-block quantity-input" value="1" min="1" max="99" style="width:70px;">
                        <button class="btn btn-success add-to-cart" data-product-id="<?= $product['id'] ?>">Add to Cart</button>
                    </div>
                </div>
            </div>
        <?php endforeach; else: ?>
            <div class="col-12 text-center">
                <div class="alert alert-info display-4">Coming Soon!</div>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php include 'includes/footer.php'; ?>
<script src="assets/js/cart.js"></script>

</body>
</html> 