-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Jul 25, 2025 at 07:29 AM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `pooja_festival`
--

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `slug` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `image_url` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` (`id`, `name`, `slug`, `description`, `image_url`, `created_at`) VALUES
(1, 'Daily Pooja', 'daily-pooja', 'Essential items for daily worship', NULL, '2025-05-31 18:52:53'),
(2, 'Festival Kits', 'festival-kits', 'Complete kits for major festivals', NULL, '2025-05-31 18:52:53'),
(3, 'Deity Specific', 'deity-specific', 'Items specific to different deities', NULL, '2025-05-31 18:52:53');

-- --------------------------------------------------------

--
-- Table structure for table `custom_kit_items`
--

CREATE TABLE `custom_kit_items` (
  `id` int(11) NOT NULL,
  `template_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `is_optional` tinyint(1) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_kit_templates`
--

CREATE TABLE `custom_kit_templates` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `base_price` decimal(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `orders`
--

CREATE TABLE `orders` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `status` enum('pending','processing','shipped','delivered','cancelled') DEFAULT 'pending',
  `shipping_address` text NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `payment_status` enum('pending','paid','failed') DEFAULT 'pending',
  `razorpay_order_id` varchar(100) DEFAULT NULL,
  `razorpay_payment_id` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `order_items`
--

CREATE TABLE `order_items` (
  `id` int(11) NOT NULL,
  `order_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `price` decimal(10,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `pooja_types`
--

CREATE TABLE `pooja_types` (
  `id` varchar(50) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `pooja_types`
--

INSERT INTO `pooja_types` (`id`, `name`, `description`, `created_at`, `updated_at`) VALUES
('daily', 'Daily Pooja', 'Regular daily worship rituals', '2025-06-11 04:01:16', '2025-06-11 04:01:16'),
('durga', 'Durga Pooja', 'Worship of Goddess Durga', '2025-06-11 04:01:16', '2025-06-11 04:01:16'),
('ganesh', 'Ganesh Pooja', 'Worship of Lord Ganesha', '2025-06-11 04:01:16', '2025-06-11 04:01:16'),
('hanuman', 'Hanuman Pooja', 'Worship of Lord Hanuman', '2025-06-11 04:01:16', '2025-06-11 04:01:16'),
('krishna', 'Krishna Pooja', 'Worship of Lord Krishna', '2025-06-11 04:01:16', '2025-06-11 04:01:16'),
('lakshmi', 'Lakshmi Pooja', 'Worship of Goddess Lakshmi', '2025-06-11 04:01:16', '2025-06-11 04:01:16'),
('navratri', 'Navratri Pooja', 'Nine nights of worship during Navratri', '2025-06-11 04:01:16', '2025-06-11 04:01:16'),
('satyanarayan', 'Satyanarayan Pooja', 'Worship of Lord Satyanarayan', '2025-06-11 04:01:16', '2025-06-11 04:01:16'),
('shiv', 'Shiv Pooja', 'Worship of Lord Shiva', '2025-06-11 04:01:16', '2025-06-11 04:01:16');

-- --------------------------------------------------------

--
-- Table structure for table `products`
--

CREATE TABLE `products` (
  `id` int(11) NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `price` decimal(10,2) NOT NULL,
  `sale_price` decimal(10,2) DEFAULT NULL,
  `stock` int(11) DEFAULT 0,
  `image_url` varchar(255) DEFAULT NULL,
  `is_featured` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `products`
--

INSERT INTO `products` (`id`, `category_id`, `name`, `slug`, `description`, `price`, `sale_price`, `stock`, `image_url`, `is_featured`, `created_at`, `updated_at`) VALUES
(1, 1, 'Daily Pooja Kit', 'daily-pooja-kit', 'Essential items including Diya, Incense Sticks, Camphor, Flowers, Haldi-Kumkum, Akshata, Bell, Coconut, Fruits, and Betel Leaves & Nuts', 999.00, NULL, 10, 'Daily Pooja Kit.webp', 1, '2025-05-31 18:52:53', '2025-06-11 08:39:08'),
(2, 2, 'Ganesh Pooja Kit', 'ganesh-pooja-kit', 'Complete kit with Ganesh Idol, Modak, Durva Grass, Red Flowers, Sandalwood Paste, Coconut, Banana, and Panchamrit', 1499.00, NULL, 10, 'Ganesh Pooja Kit.jpg', 1, '2025-05-31 18:52:53', '2025-06-11 08:38:39'),
(3, 2, 'Satyanarayan Kit', 'satyanarayan-kit', 'Premium kit containing Katha Book, Panchamrit, Banana Leaves, Fruits, Tulsi Leaves, Dry Fruits, Kalash with accessories', 1999.00, NULL, 10, 'Satyanarayan Kit.jpg', 1, '2025-05-31 18:52:53', '2025-06-11 03:44:05'),
(4, 2, 'Lakshmi Pooja Kit', 'lakshmi-pooja-kit', 'Deluxe kit with Lakshmi-Ganesh Idol, Silver Coin, Lotus Flower, Kumkum, Haldi, Dry Fruits, Sweets, and 21 Diyas', 2499.00, NULL, 10, 'Lakshmi Pooja Kit.jpg', 1, '2025-05-31 18:52:53', '2025-06-11 03:44:05'),
(5, 2, 'Navratri Special Kit', 'navratri-special-kit', 'Complete 9-day kit including Durga Idol, Kalash, Navadhanya, Red Chunri, Ghee Lamp, Coconut, and Durga Saptashati Book', 2999.00, NULL, 10, 'Navratri Special Kit.jpg', 1, '2025-05-31 18:52:53', '2025-06-11 03:44:05'),
(6, 3, 'Shiv Pooja Kit', 'shiv-pooja-kit', 'Sacred kit with Shiva Lingam, Bilva Leaves, Abhishek Items, White Flowers, Rudraksha Mala, and Bhasm', 1799.00, NULL, 10, 'Shiv Pooja Kit.jpg', 1, '2025-05-31 18:52:53', '2025-06-11 03:44:05'),
(7, 3, 'Hanuman Pooja Kit', 'hanuman-pooja-kit', 'Complete kit containing Hanuman Idol, Sindoor, Red Flowers, Laddoo, Coconut, Banana, and Hanuman Chalisa Book', 1299.00, NULL, 10, 'Hanuman Pooja Kit.webp', 1, '2025-05-31 18:52:53', '2025-06-11 03:44:05'),
(8, 2, 'Durga Pooja Kit', 'durga-pooja-kit', 'Traditional Bengali style kit with Durga Idol, Red Hibiscus, Sindoor, Fruits, Sweets, and Dhunuchi', 2799.00, NULL, 10, 'SampoornaDurgaPoojaKit01.jpg', 1, '2025-05-31 18:52:53', '2025-06-11 03:44:05'),
(9, 3, 'Krishna Pooja Kit', 'krishna-pooja-kit', 'Divine kit including Krishna-Balaram Idol, Makhan-Mishri, Tulsi Leaves, Flute, Peacock Feather, and Panchamrit', 1699.00, NULL, 10, 'Krishna Pooja Kit.jpg', 1, '2025-05-31 18:52:53', '2025-06-11 03:44:05'),
(10, 2, 'Saraswati Pooja Kit', 'saraswati-pooja-kit', 'Blessing kit with Saraswati Idol, White Flowers, Books, Musical Instruments, Kumkum, Haldi, and Yellow Cloth', 1899.00, NULL, 10, 'Saraswati Pooja Kit.jpg', 1, '2025-05-31 18:52:53', '2025-06-11 03:44:05'),
(11, 2, 'Griha Pravesh Kit', 'griha-pravesh-kit', 'House warming kit containing Kalash, Mango Leaves, Rice, Kumkum, Haldi, Coconut, and Navagraha Samagri', 2299.00, NULL, 10, 'Griha Pravesh Kit.jpg', 1, '2025-05-31 18:52:53', '2025-06-11 03:44:05'),
(12, 3, 'Rudrabhishek Kit', 'rudrabhishek-kit', 'Special Shiva kit with Lingam, Panchamrit, Ganga Jal, Bilva Leaves, Dhatura, Black Til, and Rudraksha Mala', 2199.00, NULL, 10, 'Rudrabhishek Kit.webp', 0, '2025-05-31 18:52:53', '2025-06-11 03:44:05'),
(13, 3, 'Sunderkand Path Kit', 'sunderkand-path-kit', 'Complete kit with Hanuman Idol, Red Cloth, Sindoor, Sunderkand Book, Laddoo, and Fruits', 1599.00, NULL, 10, 'Sunderkand Path Kit.jpg', 1, '2025-05-31 18:52:53', '2025-06-11 03:44:05'),
(14, 2, 'Ganpati Homam Kit', 'ganpati-homam-kit', 'Special ritual kit containing Ganesh Idol, Modak, Coconut, Havan Samagri, and Red Flowers', 1999.00, NULL, 10, 'Ganpati Homam Kit.jpg', 1, '2025-05-31 18:52:53', '2025-06-11 03:44:05'),
(15, 2, 'Satyanarayan Swamy Kit', 'satyanarayan-swamy-kit', 'Premium kit with Photo/Idol, Panchamrit, Fruits, Dry Fruits, Betel Nut, and Kalash set', 2099.00, NULL, 10, 'Satyanarayan Swamy Kit.jpg', 1, '2025-05-31 18:52:53', '2025-06-11 03:44:05');

-- Add Custom Pooja Kit product
INSERT INTO products (category_id, name, slug, description, price, stock, image_url, is_featured)
VALUES (NULL, 'Custom Pooja Kit', 'custom-pooja-kit', 'User built custom pooja kit', 0, 1000, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `product_materials`
--

CREATE TABLE `product_materials` (
  `id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `quantity` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `product_materials`
--

INSERT INTO `product_materials` (`id`, `product_id`, `name`, `quantity`) VALUES
(1, 1, 'Brass Diya', '1 piece'),
(2, 1, 'Incense Sticks', '1 pack'),
(3, 1, 'Camphor', '1 box'),
(4, 1, 'Fresh Flowers', '1 bunch'),
(5, 1, 'Haldi-Kumkum Set', '1 set'),
(6, 1, 'Akshata (Unbroken Rice)', '100g'),
(7, 1, 'Brass Bell', '1 piece'),
(8, 1, 'Coconut', '1 piece'),
(9, 1, 'Mixed Fruits', '500g'),
(10, 1, 'Betel Leaves & Nuts', '10 sets'),
(11, 2, 'Clay Ganesh Idol', '1 piece'),
(12, 2, 'Modak', '21 pieces'),
(13, 2, 'Durva Grass', '21 stalks'),
(14, 2, 'Red Hibiscus', '11 flowers'),
(15, 2, 'Sandalwood Paste', '50g'),
(16, 2, 'Coconut', '1 piece'),
(17, 2, 'Banana', '12 pieces'),
(18, 2, 'Panchamrit Set', '1 set'),
(19, 3, 'Satyanarayan Katha Book', '1 piece'),
(20, 3, 'Panchamrit Set', '1 set'),
(21, 3, 'Banana Leaves', '5 pieces'),
(22, 3, 'Mixed Fruits', '1 kg'),
(23, 3, 'Tulsi Leaves', '108 leaves'),
(24, 3, 'Mixed Dry Fruits', '500g'),
(25, 3, 'Copper Kalash Set', '1 set'),
(26, 4, 'Lakshmi-Ganesh Idol', '1 set'),
(27, 4, 'Silver Coin', '1 piece'),
(28, 4, 'Lotus Flowers', '5 pieces'),
(29, 4, 'Kumkum', '50g'),
(30, 4, 'Haldi', '50g'),
(31, 4, 'Mixed Dry Fruits', '500g'),
(32, 4, 'Laddoo', '500g'),
(33, 4, 'Brass Diyas', '21 pieces'),
(34, 5, 'Durga Idol', '1 piece'),
(35, 5, 'Brass Kalash Set', '1 set'),
(36, 5, 'Navadhanya (9 Grains)', '9 x 50g'),
(37, 5, 'Red Chunri', '1 piece'),
(38, 5, 'Ghee Lamp', '1 piece'),
(39, 5, 'Coconut', '1 piece'),
(40, 5, 'Durga Saptashati Book', '1 piece'),
(41, 6, 'Shiva Lingam', '1 piece'),
(42, 6, 'Bilva Leaves', '108 leaves'),
(43, 6, 'Milk, Honey, Curd Set', '1 set'),
(44, 6, 'White Flowers', '1 bunch'),
(45, 6, 'Rudraksha Mala', '1 piece'),
(46, 6, 'Sacred Ash (Bhasm)', '100g'),
(47, 7, 'Brass Hanuman Idol', '1 piece'),
(48, 7, 'Sindoor', '100g'),
(49, 7, 'Red Flowers', '1 bunch'),
(50, 7, 'Laddoo', '500g'),
(51, 7, 'Coconut', '1 piece'),
(52, 7, 'Banana', '12 pieces'),
(53, 7, 'Hanuman Chalisa Book', '1 piece'),
(54, 8, 'Durga Idol with Lion', '1 set'),
(55, 8, 'Red Hibiscus', '108 flowers'),
(56, 8, 'Sindoor', '200g'),
(57, 8, 'Mixed Fruits', '2 kg'),
(58, 8, 'Khichdi Prasad', '1 kg'),
(59, 8, 'Dhunuchi', '1 piece'),
(60, 9, 'Krishna-Balaram Idol', '1 set'),
(61, 9, 'Makhan-Mishri', '250g'),
(62, 9, 'Tulsi Leaves', '108 leaves'),
(63, 9, 'Decorative Flute', '1 piece'),
(64, 9, 'Peacock Feather', '1 piece'),
(65, 9, 'Panchamrit Set', '1 set'),
(66, 10, 'Saraswati Idol', '1 piece'),
(67, 10, 'White Flowers', '2 bunches'),
(68, 10, 'Blank Notebook', '1 piece'),
(69, 10, 'Musical Bell', '1 piece'),
(70, 10, 'Kumkum-Haldi Set', '1 set'),
(71, 10, 'Yellow Cloth', '1 piece'),
(72, 11, 'Brass Kalash Set', '1 set'),
(73, 11, 'Mango Leaves', '21 leaves'),
(74, 11, 'Sacred Rice', '250g'),
(75, 11, 'Kumkum-Haldi Set', '1 set'),
(76, 11, 'Coconut', '1 piece'),
(77, 11, 'Navagraha Samagri', '9 sets'),
(78, 12, 'Shiva Lingam', '1 piece'),
(79, 12, 'Panchamrit Set', '1 set'),
(80, 12, 'Ganga Jal', '200ml'),
(81, 12, 'Bilva Leaves', '108 leaves'),
(82, 12, 'Dhatura Flowers', '11 pieces'),
(83, 12, 'Black Til', '100g'),
(84, 12, 'Rudraksha Mala', '1 piece'),
(85, 13, 'Brass Hanuman Idol', '1 piece'),
(86, 13, 'Red Cotton Cloth', '1 piece'),
(87, 13, 'Sindoor', '100g'),
(88, 13, 'Sunderkand Book', '1 piece'),
(89, 13, 'Laddoo Prasad', '500g'),
(90, 13, 'Mixed Fruits', '1 kg'),
(91, 14, 'Clay Ganesh Idol', '1 piece'),
(92, 14, 'Modak', '21 pieces'),
(93, 14, 'Coconut', '2 pieces'),
(94, 14, 'Havan Samagri', '500g'),
(95, 14, 'Red Flowers', '2 bunches'),
(96, 15, 'Framed Photo', '1 piece'),
(97, 15, 'Panchamrit Set', '1 set'),
(98, 15, 'Mixed Fruits', '2 kg'),
(99, 15, 'Mixed Dry Fruits', '500g'),
(100, 15, 'Betel Nut Set', '100g'),
(101, 15, 'Brass Kalash Set', '1 set');

-- --------------------------------------------------------

--
-- Table structure for table `reviews`
--

CREATE TABLE `reviews` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `rating` int(11) NOT NULL CHECK (`rating` >= 1 and `rating` <= 5),
  `comment` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `subscriptions`
--

CREATE TABLE `subscriptions` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `frequency` enum('weekly','monthly','quarterly') NOT NULL,
  `next_delivery_date` date NOT NULL,
  `status` enum('active','paused','cancelled') DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `phone` varchar(15) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `categories`
--
ALTER TABLE `categories`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `slug` (`slug`);

--
-- Indexes for table `custom_kit_items`
--
ALTER TABLE `custom_kit_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `template_id` (`template_id`);

--
-- Indexes for table `custom_kit_templates`
--
ALTER TABLE `custom_kit_templates`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `orders`
--
ALTER TABLE `orders`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `order_items`
--
ALTER TABLE `order_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `order_id` (`order_id`),
  ADD KEY `product_id` (`product_id`);

--
-- Indexes for table `pooja_types`
--
ALTER TABLE `pooja_types`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `products`
--
ALTER TABLE `products`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `slug` (`slug`),
  ADD KEY `category_id` (`category_id`);

--
-- Indexes for table `product_materials`
--
ALTER TABLE `product_materials`
  ADD PRIMARY KEY (`id`),
  ADD KEY `product_id` (`product_id`);

--
-- Indexes for table `reviews`
--
ALTER TABLE `reviews`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `product_id` (`product_id`);

--
-- Indexes for table `subscriptions`
--
ALTER TABLE `subscriptions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `product_id` (`product_id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `email` (`email`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `categories`
--
ALTER TABLE `categories`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `custom_kit_items`
--
ALTER TABLE `custom_kit_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `custom_kit_templates`
--
ALTER TABLE `custom_kit_templates`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `orders`
--
ALTER TABLE `orders`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `order_items`
--
ALTER TABLE `order_items`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `products`
--
ALTER TABLE `products`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=16;

--
-- AUTO_INCREMENT for table `product_materials`
--
ALTER TABLE `product_materials`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=102;

--
-- AUTO_INCREMENT for table `reviews`
--
ALTER TABLE `reviews`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `subscriptions`
--
ALTER TABLE `subscriptions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `custom_kit_items`
--
ALTER TABLE `custom_kit_items`
  ADD CONSTRAINT `custom_kit_items_ibfk_1` FOREIGN KEY (`template_id`) REFERENCES `custom_kit_templates` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `orders`
--
ALTER TABLE `orders`
  ADD CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `order_items`
--
ALTER TABLE `order_items`
  ADD CONSTRAINT `order_items_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `order_items_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `products`
--
ALTER TABLE `products`
  ADD CONSTRAINT `products_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `product_materials`
--
ALTER TABLE `product_materials`
  ADD CONSTRAINT `product_materials_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `reviews`
--
ALTER TABLE `reviews`
  ADD CONSTRAINT `reviews_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `reviews_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `subscriptions`
--
ALTER TABLE `subscriptions`
  ADD CONSTRAINT `subscriptions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `subscriptions_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
