<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Custom Pooja Kit Builder - PoojaFestival.in</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <!-- Navigation (Same as index.php) -->
    <?php include 'includes/nav.php'; ?>

    <!-- Custom Kit Builder Section -->
    <div class="container py-5">
        <h1 class="text-center mb-4">Build Your Custom Pooja Kit</h1>
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-body">
                        <form id="kitBuilderForm" class="needs-validation" novalidate>
                            <!-- Step 1: Select Pooja Type -->
                            <div class="mb-4">
                                <h3 class="h5 mb-3">Step 1: Select Pooja Type</h3>
                                <select class="form-select" id="poojaType" required>
                                    <option value="">Choose Pooja Type...</option>
                                    <option value="1">Daily Pooja</option>
                                    <option value="2">Ganesh Pooja</option>
                                    <option value="3">Satyanarayan Pooja</option>
                                    <option value="4">Lakshmi Pooja</option>
                                    <option value="5">Navratri Pooja</option>
                                    <option value="6">Shiv Pooja</option>
                                    <option value="7">Hanuman Pooja</option>
                                    <option value="8">Durga Pooja</option>
                                    <option value="9">Krishna Pooja</option>
                                </select>
                            </div>

                            <!-- Step 2: Choose Materials -->
                            <div class="mb-4">
                                <h3 class="h5 mb-3">Step 2: Choose Materials</h3>
                                <div id="materialsList" class="row g-3">
                                    <!-- Materials will be dynamically loaded based on Pooja Type -->
                                </div>
                            </div>

                            <!-- Step 3: Add Extras -->
                            <div class="mb-4">
                                <h3 class="h5 mb-3">Step 3: Add Extras</h3>
                                <div class="form-check mb-2">
                                    <input class="form-check-input" type="checkbox" id="priestBooking">
                                    <label class="form-check-label" for="priestBooking">
                                        Pandit Booking Service (+₹500)
                                    </label>
                                </div>
                                <div class="form-check mb-2">
                                    <input class="form-check-input" type="checkbox" id="sameDayDelivery">
                                    <label class="form-check-label" for="sameDayDelivery">
                                        Same-Day Delivery (+₹100)
                                    </label>
                                </div>
                                <div class="form-check mb-2">
                                    <input class="form-check-input" type="checkbox" id="giftWrapping">
                                    <label class="form-check-label" for="giftWrapping">
                                        Gift Wrapping (+₹50)
                                    </label>
                                </div>
                            </div>

                            <!-- Step 4: Review & Checkout -->
                            <div class="mb-4">
                                <h3 class="h5 mb-3">Step 4: Review & Checkout</h3>
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <h4 class="h6">Your Custom Kit Summary</h4>
                                        <div id="kitSummary">
                                            <!-- Summary will be dynamically updated -->
                                        </div>
                                        <hr>
                                        <div class="d-flex justify-content-between">
                                            <span>Total Amount:</span>
                                            <span id="totalAmount" class="fw-bold">₹0</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-primary w-100">Proceed to Checkout</button>
                            <!-- Step 5: Customer Details -->
                            <div class="mb-4 mt-4">
                                <h3 class="h5 mb-3">Step 5: Your Details</h3>
                                <div class="mb-3">
                                    <label for="customerName" class="form-label">Full Name</label>
                                    <input type="text" class="form-control" id="customerName" required>
                                </div>
                                <div class="mb-3">
                                    <label for="customerEmail" class="form-label">Email Address</label>
                                    <input type="email" class="form-control" id="customerEmail" required>
                                </div>
                                <div class="mb-3">
                                    <label for="customerPassword" class="form-label">Password</label>
                                    <input type="password" class="form-control" id="customerPassword" required minlength="6">
                                </div>
                                <div class="mb-3">
                                    <label for="customerContact" class="form-label">Contact Number</label>
                                    <input type="text" class="form-control" id="customerContact" required>
                                </div>
                                <div class="mb-3">
                                    <label for="customerAddress" class="form-label">Address</label>
                                    <textarea class="form-control" id="customerAddress" rows="2" required></textarea>
                                </div>
                                <div class="mb-3">
                                    <label for="customerPincode" class="form-label">Pin Code</label>
                                    <input type="text" class="form-control" id="customerPincode" required>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer (Same as index.php) -->
    <?php include 'includes/footer.php'; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- <script src="assets/js/custom-kit.js"></script> -->

    <script type="text/javascript">
        // Remove the hardcoded poojaMaterials object

// Initialize the form when the document is ready
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('kitBuilderForm');
    const poojaTypeSelect = document.getElementById('poojaType');
    const materialsList = document.getElementById('materialsList');
    const kitSummary = document.getElementById('kitSummary');
    const totalAmountSpan = document.getElementById('totalAmount');

    // Store fetched materials for the selected type
    let currentMaterials = [];

    // Handle pooja type selection
    poojaTypeSelect.addEventListener('change', function() {
        const selectedType = this.value;
        if (selectedType) {
            fetch(`./api/get_pooja_materials.php?type=${encodeURIComponent(selectedType)}`)
                .then(res => res.json())
                .then(data => {
                    if (Array.isArray(data)) {
                        currentMaterials = data;
                        displayMaterials();
                    } else {
                        materialsList.innerHTML = '<div class="text-danger">No materials found for this pooja type.</div>';
                        currentMaterials = [];
                    }
                    updateSummary();
                })
                .catch(() => {
                    materialsList.innerHTML = '<div class="text-danger">Failed to load materials.</div>';
                    currentMaterials = [];
                    updateSummary();
                });
        } else {
            materialsList.innerHTML = '';
            currentMaterials = [];
            updateSummary();
        }
    });

    // Display materials for selected pooja type
    function displayMaterials() {
        if (!currentMaterials.length) {
            materialsList.innerHTML = '<div class="text-muted">No materials available.</div>';
            return;
        }
        materialsList.innerHTML = currentMaterials.map(item => `
            <div class="col-md-6">
                <div class="form-check">
                    <input class="form-check-input material-checkbox" type="checkbox" 
                           id="material_${item.id}" data-price="${item.price || 0}">
                    <label class="form-check-label" for="material_${item.id}">
                        ${item.name}${item.quantity ? ` (${item.quantity})` : ''}${item.price ? ` (₹${item.price})` : ''}
                    </label>
                </div>
            </div>
        `).join('');

        // Add event listeners to new checkboxes
        document.querySelectorAll('.material-checkbox').forEach(checkbox => {
            checkbox.addEventListener('change', updateSummary);
        });
    }

    // Update kit summary and total
    function updateSummary() {
        let total = 0;
        let summaryHTML = '';

        // Calculate materials cost
        document.querySelectorAll('.material-checkbox:checked').forEach(checkbox => {
            const price = parseInt(checkbox.dataset.price) || 0;
            const label = checkbox.nextElementSibling.textContent;
            total += price;
            summaryHTML += `<div>${label}</div>`;
        });

        // Add extras cost
        if (document.getElementById('priestBooking').checked) {
            total += 500;
            summaryHTML += '<div>Pandit Booking Service (+₹500)</div>';
        }
        if (document.getElementById('sameDayDelivery').checked) {
            total += 100;
            summaryHTML += '<div>Same-Day Delivery (+₹100)</div>';
        }
        if (document.getElementById('giftWrapping').checked) {
            total += 50;
            summaryHTML += '<div>Gift Wrapping (+₹50)</div>';
        }

        // Update the summary and total in the UI
        kitSummary.innerHTML = summaryHTML || '<div class="text-muted">No items selected</div>';
        totalAmountSpan.textContent = `₹${total}`;
    }

    // Add event listeners for extras
    document.getElementById('priestBooking').addEventListener('change', updateSummary);
    document.getElementById('sameDayDelivery').addEventListener('change', updateSummary);
    document.getElementById('giftWrapping').addEventListener('change', updateSummary);

    // Handle form submission
    form.addEventListener('submit', function(e) {
        e.preventDefault();

        // Validate form
        if (!poojaTypeSelect.value) {
            alert('Please select a Pooja type');
            return;
        }
        const selectedMaterials = document.querySelectorAll('.material-checkbox:checked');
        if (selectedMaterials.length === 0) {
            alert('Please select at least one material');
            return;
        }

        // Get customer details
        const customerName = document.getElementById('customerName').value.trim();
        const customerEmail = document.getElementById('customerEmail').value.trim();
        const customerPassword = document.getElementById('customerPassword').value;
        const customerContact = document.getElementById('customerContact').value.trim();
        const customerAddress = document.getElementById('customerAddress').value.trim();
        const customerPincode = document.getElementById('customerPincode').value.trim();

        if (!customerName || !customerEmail || !customerPassword || !customerContact || !customerAddress || !customerPincode) {
            alert('Please fill in all your details');
            return;
        }
        if (customerPassword.length < 6) {
            alert('Password must be at least 6 characters long');
            return;
        }

        // Gather order data
        const orderData = {
            poojaType: poojaTypeSelect.value,
            materials: Array.from(selectedMaterials).map(cb => ({
                id: cb.id.replace('material_', ''),
                name: cb.nextElementSibling.textContent,
                price: cb.dataset.price
            })),
            extras: {
                priestBooking: document.getElementById('priestBooking').checked,
                sameDayDelivery: document.getElementById('sameDayDelivery').checked,
                giftWrapping: document.getElementById('giftWrapping').checked
            },
            customer: {
                name: customerName,
                email: customerEmail,
                password: customerPassword,
                contact: customerContact,
                address: customerAddress,
                pincode: customerPincode
            }
        };

        // Send to backend
        fetch('./api/save_custom_order.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(orderData)
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                alert('Order placed successfully!');
                form.reset();
                kitSummary.innerHTML = '';
                totalAmountSpan.textContent = '₹0';
            } else {
                alert('Failed to place order. Please try again.');
            }
        })
        .catch(() => {
            alert('Failed to place order. Please try again.');
        });
    });
});
    </script>
</body>
</html>