<?php
require_once __DIR__ . '/../config/database.php';

class Order {
    private $id;
    private $user_id;
    private $total_amount;
    private $status;
    private $shipping_address;
    private $payment_method;
    private $payment_status;
    private $razorpay_order_id;
    private $razorpay_payment_id;
    private $created_at;

    // Create new order
    public static function createOrder($data) {
        $conn = connectDB();
        if (!$conn) {
            return false;
        }

        $user_id = isset($data['user_id']) ? (int)$data['user_id'] : 'NULL';
        $total_amount = (float)$data['total_amount'];
        $shipping_address = $conn->real_escape_string($data['shipping_address']);
        $payment_method = $conn->real_escape_string($data['payment_method']);
        $status = $conn->real_escape_string($data['status']);
        $payment_status = $conn->real_escape_string($data['payment_status']);

        $query = "INSERT INTO orders (user_id, total_amount, shipping_address, payment_method, status, payment_status) 
                  VALUES ($user_id, $total_amount, '$shipping_address', '$payment_method', '$status', '$payment_status')";

        if ($conn->query($query)) {
            $orderId = $conn->insert_id;
            closeDB($conn);
            return $orderId;
        }

        closeDB($conn);
        return false;
    }

    // Add order item
    public static function addOrderItem($order_id, $product_id, $quantity, $price) {
        $conn = connectDB();
        if (!$conn) {
            return false;
        }

        $order_id = (int)$order_id;
        $product_id = (int)$product_id;
        $quantity = (int)$quantity;
        $price = (float)$price;

        $query = "INSERT INTO order_items (order_id, product_id, quantity, price) 
                  VALUES ($order_id, $product_id, $quantity, $price)";

        $result = $conn->query($query);
        closeDB($conn);
        return $result;
    }

    // Get order by ID
    public static function getOrderById($id) {
        $id = (int)$id;
        $query = "SELECT * FROM orders WHERE id = $id";
        return getRow($query);
    }

    // Get order with items
    public static function getOrderWithItems($id) {
        $id = (int)$id;
        $order = self::getOrderById($id);
        
        if ($order) {
            $order['items'] = self::getOrderItems($id);
        }
        
        return $order;
    }

    // Get order items
    public static function getOrderItems($order_id) {
        $order_id = (int)$order_id;
        $query = "SELECT oi.*, p.name, p.image_url 
                  FROM order_items oi 
                  JOIN products p ON oi.product_id = p.id 
                  WHERE oi.order_id = $order_id";
        return getRows($query);
    }

    // Get user orders
    public static function getUserOrders($userId) {
        $userId = (int)$userId;
        $query = "SELECT o.*, COUNT(oi.id) as items_count 
                  FROM orders o 
                  LEFT JOIN order_items oi ON o.id = oi.order_id 
                  WHERE o.user_id = $userId 
                  GROUP BY o.id 
                  ORDER BY o.created_at DESC";
        return getRows($query);
    }

    // Update order status
    public static function updateOrderStatus($order_id, $status) {
        $conn = connectDB();
        if (!$conn) {
            return false;
        }

        $order_id = (int)$order_id;
        $status = $conn->real_escape_string($status);

        $query = "UPDATE orders SET status = '$status' WHERE id = $order_id";
        $result = $conn->query($query);
        closeDB($conn);
        return $result;
    }

    // Update payment status
    public static function updatePaymentStatus($order_id, $payment_status, $razorpay_order_id = null, $razorpay_payment_id = null) {
        $conn = connectDB();
        if (!$conn) {
            return false;
        }

        $order_id = (int)$order_id;
        $payment_status = $conn->real_escape_string($payment_status);
        $razorpay_order_id = $razorpay_order_id ? "'" . $conn->real_escape_string($razorpay_order_id) . "'" : 'NULL';
        $razorpay_payment_id = $razorpay_payment_id ? "'" . $conn->real_escape_string($razorpay_payment_id) . "'" : 'NULL';

        $query = "UPDATE orders SET payment_status = '$payment_status', 
                  razorpay_order_id = $razorpay_order_id, 
                  razorpay_payment_id = $razorpay_payment_id 
                  WHERE id = $order_id";

        $result = $conn->query($query);
        closeDB($conn);
        return $result;
    }

    // Get all orders (for admin)
    public static function getAllOrders($limit = null, $offset = 0) {
        $query = "SELECT o.*, u.name as customer_name, u.email as customer_email 
                  FROM orders o 
                  LEFT JOIN users u ON o.user_id = u.id 
                  ORDER BY o.created_at DESC";
        
        if ($limit) {
            $query .= " LIMIT " . (int)$limit . " OFFSET " . (int)$offset;
        }
        
        return getRows($query);
    }

    // Get orders by status
    public static function getOrdersByStatus($status) {
        $status = sanitizeInput($status);
        $query = "SELECT * FROM orders WHERE status = '$status' ORDER BY created_at DESC";
        return getRows($query);
    }

    // Get total orders count
    public static function getTotalOrdersCount() {
        $query = "SELECT COUNT(*) as count FROM orders";
        $result = getRow($query);
        return $result ? $result['count'] : 0;
    }

    // Get total revenue
    public static function getTotalRevenue() {
        $query = "SELECT SUM(total_amount) as total FROM orders WHERE payment_status = 'paid'";
        $result = getRow($query);
        return $result ? $result['total'] : 0;
    }

    // Delete order (admin only)
    public static function deleteOrder($id) {
        $id = (int)$id;
        
        // First delete order items
        $conn = connectDB();
        if (!$conn) {
            return false;
        }

        $conn->query("DELETE FROM order_items WHERE order_id = $id");
        $result = $conn->query("DELETE FROM orders WHERE id = $id");
        closeDB($conn);
        
        return $result;
    }

    // Get order statistics
    public static function getOrderStats() {
        $stats = [];
        
        // Total orders
        $stats['total_orders'] = self::getTotalOrdersCount();
        
        // Pending orders
        $pending = self::getOrdersByStatus('pending');
        $stats['pending_orders'] = count($pending);
        
        // Processing orders
        $processing = self::getOrdersByStatus('processing');
        $stats['processing_orders'] = count($processing);
        
        // Shipped orders
        $shipped = self::getOrdersByStatus('shipped');
        $stats['shipped_orders'] = count($shipped);
        
        // Delivered orders
        $delivered = self::getOrdersByStatus('delivered');
        $stats['delivered_orders'] = count($delivered);
        
        // Total revenue
        $stats['total_revenue'] = self::getTotalRevenue();
        
        return $stats;
    }

    // Validate order belongs to user
    public static function validateOrderOwnership($order_id, $user_id) {
        $order_id = (int)$order_id;
        $user_id = (int)$user_id;
        
        $query = "SELECT id FROM orders WHERE id = $order_id AND user_id = $user_id";
        $result = getRow($query);
        
        return !empty($result);
    }

    // Get order by Razorpay order ID
    public static function getOrderByRazorpayId($razorpay_order_id) {
        $razorpay_order_id = sanitizeInput($razorpay_order_id);
        $query = "SELECT * FROM orders WHERE razorpay_order_id = '$razorpay_order_id'";
        return getRow($query);
    }
}
?>