<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Start session if not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/classes/Cart.php';

// Log incoming request
error_log('Cart action request: ' . print_r($_POST, true));
error_log('Session ID: ' . session_id());
error_log('Session data: ' . print_r($_SESSION, true));

if (!isset($_POST['action'])) {
    http_response_code(400);
    echo json_encode(['error' => 'No action specified']);
    exit;
}

$cart = new Cart();
$action = $_POST['action'];
$response = ['success' => false];

switch ($action) {
    case 'add':
        if (isset($_POST['product_id']) && isset($_POST['quantity'])) {
            error_log("Processing add action: product_id=" . $_POST['product_id'] . ", quantity=" . $_POST['quantity']);
            
            $success = $cart->addItem(
                intval($_POST['product_id']), 
                intval($_POST['quantity'])
            );
            
            $response = [
                'success' => $success,
                'cartCount' => $cart->getItemCount(),
                'cartTotal' => $cart->getTotal(),
                'message' => $success ? 'Product added successfully' : 'Failed to add product'
            ];
            
            error_log("Add response: " . print_r($response, true));
        } else {
            $response = ['success' => false, 'error' => 'Missing product_id or quantity'];
        }
        break;

    case 'update':
        if (isset($_POST['product_id']) && isset($_POST['quantity'])) {
            $cart->updateQuantity(
                intval($_POST['product_id']), 
                intval($_POST['quantity'])
            );
            $response = [
                'success' => true,
                'cartCount' => $cart->getItemCount(),
                'cartTotal' => $cart->getTotal()
            ];
        }
        break;

    case 'remove':
        if (isset($_POST['product_id'])) {
            $cart->removeItem(intval($_POST['product_id']));
            $response = [
                'success' => true,
                'cartCount' => $cart->getItemCount(),
                'cartTotal' => $cart->getTotal()
            ];
        }
        break;

    case 'clear':
        $cart->clear();
        $response = [
            'success' => true,
            'cartCount' => 0,
            'cartTotal' => 0
        ];
        break;

    case 'get':
        $response = [
            'success' => true,
            'items' => $cart->getItems(),
            'cartCount' => $cart->getItemCount(),
            'cartTotal' => $cart->getTotal()
        ];
        break;

    default:
        http_response_code(400);
        $response = ['error' => 'Invalid action'];
}

// Ensure proper JSON response
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-cache, must-revalidate');
echo json_encode($response, JSON_UNESCAPED_UNICODE);