// Remove the hardcoded poojaMaterials object

// Initialize the form when the document is ready
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('kitBuilderForm');
    const poojaTypeSelect = document.getElementById('poojaType');
    const materialsList = document.getElementById('materialsList');
    const kitSummary = document.getElementById('kitSummary');
    const totalAmountSpan = document.getElementById('totalAmount');

    // Store fetched materials for the selected type
    let currentMaterials = [];

    // Handle pooja type selection
    poojaTypeSelect.addEventListener('change', function() {
        const selectedType = this.value;
        if (selectedType) {
            fetch(`../api/get_pooja_materials.php?type=${encodeURIComponent(selectedType)}`)
                .then(res => res.json())
                .then(data => {
                    if (Array.isArray(data)) {
                        currentMaterials = data;
                        displayMaterials();
                    } else {
                        materialsList.innerHTML = '<div class="text-danger">No materials found for this pooja type.</div>';
                        currentMaterials = [];
                    }
                    updateSummary();
                })
                .catch(() => {
                    materialsList.innerHTML = '<div class="text-danger">Failed to load materials.</div>';
                    currentMaterials = [];
                    updateSummary();
                });
        } else {
            materialsList.innerHTML = '';
            currentMaterials = [];
            updateSummary();
        }
    });

    // Display materials for selected pooja type
    function displayMaterials() {
        if (!currentMaterials.length) {
            materialsList.innerHTML = '<div class="text-muted">No materials available.</div>';
            return;
        }
        materialsList.innerHTML = currentMaterials.map(item => `
            <div class="col-md-6">
                <div class="form-check">
                    <input class="form-check-input material-checkbox" type="checkbox" 
                           id="material_${item.id}" data-price="${item.price || 0}">
                    <label class="form-check-label" for="material_${item.id}">
                        ${item.name}${item.quantity ? ` (${item.quantity})` : ''}${item.price ? ` (₹${item.price})` : ''}
                    </label>
                </div>
            </div>
        `).join('');

        // Add event listeners to new checkboxes
        document.querySelectorAll('.material-checkbox').forEach(checkbox => {
            checkbox.addEventListener('change', updateSummary);
        });
    }

    // Update kit summary and total
    function updateSummary() {
        let total = 0;
        let summaryHTML = '';

        // Calculate materials cost
        document.querySelectorAll('.material-checkbox:checked').forEach(checkbox => {
            const price = parseInt(checkbox.dataset.price) || 0;
            const label = checkbox.nextElementSibling.textContent;
            total += price;
            summaryHTML += `<div>${label}</div>`;
        });

        // Add extras cost
        if (document.getElementById('priestBooking').checked) {
            total += 500;
            summaryHTML += '<div>Pandit Booking Service (+₹500)</div>';
        }
        if (document.getElementById('sameDayDelivery').checked) {
            total += 100;
            summaryHTML += '<div>Same-Day Delivery (+₹100)</div>';
        }
        if (document.getElementById('giftWrapping').checked) {
            total += 50;
            summaryHTML += '<div>Gift Wrapping (+₹50)</div>';
        }

        // Update the summary and total in the UI
        kitSummary.innerHTML = summaryHTML || '<div class="text-muted">No items selected</div>';
        totalAmountSpan.textContent = `₹${total}`;
    }

    // Add event listeners for extras
    document.getElementById('priestBooking').addEventListener('change', updateSummary);
    document.getElementById('sameDayDelivery').addEventListener('change', updateSummary);
    document.getElementById('giftWrapping').addEventListener('change', updateSummary);

    // Handle form submission
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        // Validate form
        if (!poojaTypeSelect.value) {
            alert('Please select a Pooja type');
            return;
        }

        const selectedMaterials = document.querySelectorAll('.material-checkbox:checked');
        if (selectedMaterials.length === 0) {
            alert('Please select at least one material');
            return;
        }

        // Here you would typically send the form data to your backend
        alert('Proceeding to checkout...');
        // Add your checkout logic here
    });
});