<?php
require_once '../config/database.php';

header('Content-Type: application/json');
$data = json_decode(file_get_contents('php://input'), true);

if (!$data) {
    echo json_encode(['success' => false, 'error' => 'No data received']);
    exit;
}

// Extract customer info
$name = sanitizeInput($data['customer']['name'] ?? '');
$email = sanitizeInput($data['customer']['email'] ?? '');
$password = $data['customer']['password'] ?? '';
$contact = sanitizeInput($data['customer']['contact'] ?? '');
$address = sanitizeInput($data['customer']['address'] ?? '');
$pincode = sanitizeInput($data['customer']['pincode'] ?? '');
$full_address = $address . ', ' . $pincode;

if (!$name || !$email || !$password || !$contact || !$address || !$pincode) {
    echo json_encode(['success' => false, 'error' => 'Missing customer details']);
    exit;
}

// Check if email already exists
$checkEmailQuery = "SELECT id FROM users WHERE email = '$email' LIMIT 1";
$existingUser = getRow($checkEmailQuery);
if ($existingUser) {
    echo json_encode(['success' => false, 'error' => 'Email already registered. Please use another email.']);
    exit;
}

// Hash the password
$hashedPassword = password_hash($password, PASSWORD_DEFAULT);

// Insert user
$userQuery = "INSERT INTO users (name, email, password, phone, address) VALUES ('$name', '$email', '$hashedPassword', '$contact', '$full_address')";
$userId = insertRecord($userQuery);

if (!$userId) {
    echo json_encode(['success' => false, 'error' => 'Failed to save user']);
    exit;
}

// Calculate total amount
$total = 0;
foreach ($data['materials'] as $item) {
    $total += (int)$item['price'];
}
if (!empty($data['extras']['priestBooking'])) $total += 500;
if (!empty($data['extras']['sameDayDelivery'])) $total += 100;
if (!empty($data['extras']['giftWrapping'])) $total += 50;

// Insert order
$orderQuery = "INSERT INTO orders (user_id, total_amount, shipping_address, payment_method, payment_status) VALUES ($userId, $total, '$full_address', 'COD', 'pending')";
$orderId = insertRecord($orderQuery);

if (!$orderId) {
    echo json_encode(['success' => false, 'error' => 'Failed to save order']);
    exit;
}

// Save selected materials as JSON
$materials_json = json_encode($data['materials']);

// Get the product ID for 'Custom Pooja Kit'
$customKitProductQuery = "SELECT id FROM products WHERE slug = 'custom-pooja-kit' LIMIT 1";
$customKitProduct = getRow($customKitProductQuery);
$custom_kit_product_id = $customKitProduct ? (int)$customKitProduct['id'] : 0;

if (!$custom_kit_product_id) {
    echo json_encode(['success' => false, 'error' => 'Custom Kit product not found.']);
    exit;
}

// Insert order item for the custom kit
$orderItemQuery = "INSERT INTO order_items (order_id, product_id, quantity, price) VALUES ($orderId, $custom_kit_product_id, 1, $total)";
insertRecord($orderItemQuery);

// Optionally, save the materials JSON in a new table
$customKitQuery = "INSERT INTO custom_kit_orders (order_id, materials_json) VALUES ($orderId, '" . addslashes($materials_json) . "')";
insertRecord($customKitQuery);

echo json_encode(['success' => true]); 