<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>About Us - PoojaFestival.in</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .about-hero {
            background: url('assets/images/Hero/Ganesh Pooja.webp') center center/cover no-repeat;
            min-height: 320px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #fff;
            position: relative;
        }
        .about-hero::after {
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            background: rgba(34, 34, 34, 0.5);
        }
        .about-hero-content {
            position: relative;
            z-index: 2;
        }
        .about-feature-icon {
            font-size: 2.5rem;
            color: #e67e22;
        }
    </style>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
</head>
<body>
<?php include 'includes/nav.php'; ?>
<div class="about-hero mb-5">
    <div class="about-hero-content text-center">
        <h1 class="display-4 fw-bold">🙏 About Us</h1>
        <p class="lead">Tradition. Trust. Convenience.</p>
    </div>
</div>
<div class="container pb-5">
    <div class="row justify-content-center mb-4">
        <div class="col-md-10">
            <div class="bg-white rounded-4 shadow p-4">
                <div class="row align-items-center">
                    <div class="col-md-4 text-center mb-3 mb-md-0">
                        <img src="assets/images/Hero/Lakshmi Pooja.jpg" alt="Family Pandits" class="img-fluid rounded-3 shadow" style="max-height: 220px; object-fit: cover;">
                    </div>
                    <div class="col-md-8">
                        <h2 class="fw-bold mb-3">A Legacy of Spiritual Service</h2>
                        <p class="mb-2">We are a <b>Mumbai-based family business</b>, proudly rooted in generations of spiritual service as traditional Pandits. From grandfather to father to son, our lineage is steeped in Vedic knowledge, rituals, and devotion.</p>
                        <p class="mb-2">Driven by the belief that no one should have to struggle to find the right pooja materials, we created a simple yet powerful solution—<b>a complete pooja kit</b>, thoughtfully curated to include everything you need, delivered promptly and with care.</p>
                        <p class="mb-0">Whether you're performing a Ganesh Pooja, Satyanarayan Katha, Griha Pravesh, or any sacred ritual, our aim is to remove the hassle of gathering items and ensure that your spiritual experience is smooth and fulfilling. With our kits, you'll never miss an essential item again.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row justify-content-center mb-5">
        <div class="col-md-10">
            <div class="bg-light rounded-4 shadow-sm p-4">
                <h3 class="text-center mb-4">Why Choose PoojaFestival.in?</h3>
                <div class="row g-4">
                    <div class="col-md-4 text-center">
                        <div class="about-feature-icon mb-2"><i class="bi bi-shield-check"></i></div>
                        <h5>Trust</h5>
                        <p>We don’t just deliver products—we deliver trust. Every kit is packed with care and authenticity, ensuring you receive only the best.</p>
                    </div>
                    <div class="col-md-4 text-center">
                        <div class="about-feature-icon mb-2"><i class="bi bi-bookmark-heart"></i></div>
                        <h5>Tradition</h5>
                        <p>Our family’s Vedic knowledge and ritual expertise are woven into every kit, preserving the sanctity of your pooja experience.</p>
                    </div>
                    <div class="col-md-4 text-center">
                        <div class="about-feature-icon mb-2"><i class="bi bi-truck"></i></div>
                        <h5>Convenience</h5>
                        <p>No more running around for pooja items. Get everything you need, delivered to your doorstep, so you can focus on devotion.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="bg-white rounded-4 shadow p-4 text-center">
                <h4 class="mb-3">Serving Mumbai &amp; Beyond</h4>
                <img src="assets/images/Hero/Satyanarayan Pooja.webp" alt="Mumbai" class="img-fluid rounded-3 shadow mb-3" style="max-height: 180px; object-fit: cover;">
                <p class="mb-0">From the heart of Mumbai to homes across India, we are honored to be part of your sacred moments. Thank you for trusting us with your pooja needs.</p>
            </div>
        </div>
    </div>
</div>
<?php include 'includes/footer.php'; ?>
</body>
</html> 