<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/classes/Product.php';

echo "<h2>Database Connection Test</h2>";

// Test database connection
$conn = connectDB();
if ($conn) {
    echo "<p style='color: green;'>✓ Database connection successful</p>";
    
    // Test product retrieval
    $product = Product::getProductById(1);
    if ($product) {
        echo "<p style='color: green;'>✓ Product retrieval successful</p>";
        echo "<pre>Product data: " . print_r($product, true) . "</pre>";
    } else {
        echo "<p style='color: red;'>✗ Product retrieval failed</p>";
    }
    
    closeDB($conn);
} else {
    echo "<p style='color: red;'>✗ Database connection failed</p>";
}

// Test session
if (!isset($_SESSION)) {
    session_start();
}
echo "<p>Session ID: " . session_id() . "</p>";
echo "<p>Session data: " . print_r($_SESSION, true) . "</p>";
?> 