<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Direct Cart Test</h2>";

// Test database connection
require_once __DIR__ . '/config/database.php';
$conn = connectDB();

if ($conn) {
    echo "<p style='color: green;'>✓ Database connection successful</p>";
    
    // Test product retrieval
    require_once __DIR__ . '/classes/Product.php';
    $product = Product::getProductById(1);
    
    if ($product) {
        echo "<p style='color: green;'>✓ Product found</p>";
        echo "<pre>Product: " . print_r($product, true) . "</pre>";
        
        // Test cart functionality
        require_once __DIR__ . '/classes/Cart.php';
        
        // Start session
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
        
        $cart = new Cart();
        echo "<p>Session ID: " . session_id() . "</p>";
        echo "<p>Initial cart items: " . count($cart->getItems()) . "</p>";
        
        // Test adding item
        $success = $cart->addItem(1, 2);
        echo "<p>Add item result: " . ($success ? 'Success' : 'Failed') . "</p>";
        echo "<p>Cart items after adding: " . count($cart->getItems()) . "</p>";
        echo "<p>Cart total: ₹" . $cart->getTotal() . "</p>";
        echo "<p>Cart count: " . $cart->getItemCount() . "</p>";
        
        echo "<pre>Cart items: " . print_r($cart->getItems(), true) . "</pre>";
        
    } else {
        echo "<p style='color: red;'>✗ Product not found</p>";
    }
    
    closeDB($conn);
} else {
    echo "<p style='color: red;'>✗ Database connection failed</p>";
}

// Test cart-actions.php via POST
echo "<h3>Testing cart-actions.php</h3>";
echo "<form method='post' action='cart-actions.php'>";
echo "<input type='hidden' name='action' value='add'>";
echo "<input type='hidden' name='product_id' value='1'>";
echo "<input type='hidden' name='quantity' value='1'>";
echo "<button type='submit'>Test Add to Cart</button>";
echo "</form>";

// If form was submitted, show the response
if ($_POST) {
    echo "<h4>Form submitted:</h4>";
    echo "<pre>" . print_r($_POST, true) . "</pre>";
}
?> 