<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/classes/Product.php';
require_once __DIR__ . '/classes/Cart.php';

// Initialize database connection
$db = connectDB();
if (!$db) {
    die('Database connection failed');
}

// Create Product instance
$productObj = new Product();

// Get filter parameters
$category = isset($_GET['category']) ? $_GET['category'] : null;
$sort = isset($_GET['sort']) ? $_GET['sort'] : 'name_asc';
$search = isset($_GET['search']) ? $_GET['search'] : '';

// Get products based on filters
$products = $productObj->getProducts($category, $sort, $search);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shop - PoojaFestival.in</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <!-- Navigation -->
    <?php include 'includes/nav.php'; ?>

    <!-- Shop Header -->
    <div class="shop-header py-4 bg-light">
        <div class="container">
            <h1 class="text-center mb-4">Shop Pooja Samagri</h1>
            
            <!-- Search and Filter Bar -->
            <div class="row g-3 align-items-center justify-content-between mb-4">
                <div class="col-md-4">
                    <form class="d-flex" action="shop.php" method="GET">
                        <input type="text" class="form-control me-2" name="search" placeholder="Search products..." value="<?php echo htmlspecialchars($search); ?>">
                        <button class="btn btn-primary" type="submit"><i class="bi bi-search"></i></button>
                    </form>
                </div>
                <div class="col-md-4">
                    <select class="form-select" onchange="window.location.href=this.value">
                        <option value="shop.php?sort=name_asc" <?php echo $sort == 'name_asc' ? 'selected' : ''; ?>>Name (A-Z)</option>
                        <option value="shop.php?sort=name_desc" <?php echo $sort == 'name_desc' ? 'selected' : ''; ?>>Name (Z-A)</option>
                        <option value="shop.php?sort=price_asc" <?php echo $sort == 'price_asc' ? 'selected' : ''; ?>>Price (Low to High)</option>
                        <option value="shop.php?sort=price_desc" <?php echo $sort == 'price_desc' ? 'selected' : ''; ?>>Price (High to Low)</option>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <!-- Product Grid -->
    <div class="container py-5">
        <?php if (empty($products)): ?>
        <div class="alert alert-info text-center">
            No products found. Please try a different search or category.
        </div>
        <?php else: ?>
        <div class="row g-4">
            <?php foreach ($products as $product): ?>
            <div class="col-md-4 col-lg-3">
                <div class="card product-card h-100">
                    <div class="card-badge">
                        <?php if ($product['sale_price']): ?>
                            <span class="badge bg-danger">Sale</span>
                        <?php endif; ?>
                        <?php if ($product['is_featured']): ?>
                            <span class="badge bg-primary">Featured</span>
                        <?php endif; ?>
                    </div>
                    <img src="./assets/images/<?php echo htmlspecialchars($product['image_url']); ?>" class="card-img-top" alt="<?php echo htmlspecialchars($product['name']); ?>">
                    <div class="card-body d-flex flex-column">
                        <h5 class="card-title"><?php echo htmlspecialchars($product['name']); ?></h5>
                        <p class="card-text flex-grow-1"><?php echo htmlspecialchars($product['description']); ?></p>
                        <div class="product-price mb-3">
                            <?php if ($product['sale_price']): ?>
                                <span class="text-decoration-line-through text-muted">₹<?php echo number_format($product['price'], 2); ?></span>
                                <span class="text-danger ms-2">₹<?php echo number_format($product['sale_price'], 2); ?></span>
                            <?php else: ?>
                                <span class="text-primary">₹<?php echo number_format($product['price'], 2); ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="price-container">
                                <?php if ($product['sale_price']): ?>
                                    <span class="text-decoration-line-through text-muted">₹<?php echo number_format($product['price'], 2); ?></span>
                                    <span class="ms-2 text-danger">₹<?php echo number_format($product['sale_price'], 2); ?></span>
                                <?php else: ?>
                                    <span>₹<?php echo number_format($product['price'], 2); ?></span>
                                <?php endif; ?>
                            </div>
                            <div class="quantity-input-group">
                                <input type="number" class="form-control form-control-sm quantity-input" 
                                       value="1" min="1" max="99" style="width: 60px">
                            </div>
                        </div>

                        <div class="d-grid gap-2">
                            <button class="btn btn-primary add-to-cart" 
                                    data-product-id="<?php echo $product['id']; ?>">
                                <i class="bi bi-cart-plus"></i> Add to Cart
                            </button>
                            <a href="product.php?id=<?php echo $product['id']; ?>" 
                               class="btn btn-outline-secondary">View Details</a>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script src="assets/js/cart.js"></script>
    <script src="assets/js/main.js"></script>
    <script>
    // Debug cart functionality
    $(document).ready(function() {
        console.log('jQuery loaded successfully in shop.php');
        console.log('jQuery version:', $.fn.jquery);
        console.log('ShoppingCart object:', typeof ShoppingCart);
        
        // Test if add to cart buttons exist
        const addToCartButtons = $('.add-to-cart');
        console.log('Found add to cart buttons:', addToCartButtons.length);
        
        addToCartButtons.each(function() {
            console.log('Button data:', $(this).data());
        });
        
        // Test cart functionality
        if (typeof ShoppingCart !== 'undefined') {
            console.log('ShoppingCart is available and ready');
            // Load initial cart count
            ShoppingCart.refreshCartCount();
        } else {
            console.error('ShoppingCart is not available');
        }
    });
    
    // Fallback check for jQuery
    setTimeout(function() {
        if (typeof $ === 'undefined') {
            console.error('jQuery failed to load in shop.php');
        } else {
            console.log('jQuery is available in shop.php');
        }
    }, 1000);
    </script>
</body>
</html>