<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/classes/Order.php';

// Start session
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Check if order ID is provided
if (!isset($_GET['order_id'])) {
    header('Location: index.php');
    exit;
}

$orderId = (int)$_GET['order_id'];
$order = Order::getOrderById($orderId);

if (!$order) {
    header('Location: index.php');
    exit;
}

// Verify order belongs to user (if logged in)
if (isset($_SESSION['user_id'])) {
    if (!Order::validateOrderOwnership($orderId, $_SESSION['user_id'])) {
        header('Location: index.php');
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Failed - PoojaFestival.in</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <!-- Navigation -->
    <?php include 'includes/nav.php'; ?>

    <div class="container my-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card border-danger">
                    <div class="card-body text-center">
                        <div class="mb-4">
                            <i class="bi bi-x-circle text-danger" style="font-size: 5rem;"></i>
                        </div>
                        
                        <h2 class="text-danger mb-3">Payment Failed</h2>
                        <p class="lead mb-4">We're sorry, but your payment could not be processed. Please try again.</p>
                        
                        <div class="alert alert-warning">
                            <h5>Order Details</h5>
                            <p><strong>Order ID:</strong> #<?php echo $orderId; ?></p>
                            <p><strong>Total Amount:</strong> ₹<?php echo number_format($order['total_amount'], 2); ?></p>
                            <p><strong>Payment Status:</strong> <span class="badge bg-danger">Failed</span></p>
                            <p><strong>Order Status:</strong> <span class="badge bg-warning">Pending</span></p>
                        </div>
                        
                        <div class="row mt-4">
                            <div class="col-md-6">
                                <h6>Possible Reasons</h6>
                                <ul class="text-start">
                                    <li>Insufficient funds in your account</li>
                                    <li>Card details entered incorrectly</li>
                                    <li>Card expired or blocked</li>
                                    <li>Network connectivity issues</li>
                                    <li>Bank declined the transaction</li>
                                </ul>
                            </div>
                            
                            <div class="col-md-6">
                                <h6>What You Can Do</h6>
                                <ul class="text-start">
                                    <li>Check your payment method</li>
                                    <li>Ensure sufficient balance</li>
                                    <li>Try a different payment method</li>
                                    <li>Contact your bank if needed</li>
                                    <li>Try again in a few minutes</li>
                                </ul>
                            </div>
                        </div>
                        
                        <div class="d-grid gap-2 d-md-flex justify-content-md-center mt-4">
                            <a href="process_payment.php?order_id=<?php echo $orderId; ?>" class="btn btn-primary">
                                <i class="bi bi-arrow-clockwise"></i> Try Again
                            </a>
                            <a href="checkout.php" class="btn btn-outline-primary">
                                <i class="bi bi-credit-card"></i> Use Different Payment Method
                            </a>
                            <a href="cart.php" class="btn btn-outline-secondary">
                                <i class="bi bi-cart"></i> Back to Cart
                            </a>
                        </div>
                    </div>
                </div>
                
                <!-- Help Section -->
                <div class="card mt-4">
                    <div class="card-body">
                        <h5><i class="bi bi-question-circle"></i> Need Help?</h5>
                        <div class="row">
                            <div class="col-md-4 text-center">
                                <i class="bi bi-telephone text-primary" style="font-size: 2rem;"></i>
                                <h6 class="mt-2">Call Us</h6>
                                <p class="text-muted small">+91 98765 43210</p>
                            </div>
                            <div class="col-md-4 text-center">
                                <i class="bi bi-envelope text-info" style="font-size: 2rem;"></i>
                                <h6 class="mt-2">Email Support</h6>
                                <p class="text-muted small">support@poojafestival.in</p>
                            </div>
                            <div class="col-md-4 text-center">
                                <i class="bi bi-chat-dots text-success" style="font-size: 2rem;"></i>
                                <h6 class="mt-2">Live Chat</h6>
                                <p class="text-muted small">Available 24/7</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script src="assets/js/cart.js"></script>
</body>
</html> 