<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PoojaFestival.in - Your One-Stop Shop for Pooja Essentials</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <!-- Navigation -->
   <?php include 'includes/nav.php'; ?>

    <!-- Hero Banner Carousel -->
    <div id="heroCarousel" class="carousel slide" data-bs-ride="carousel">
        <div class="carousel-indicators">
            <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="0" class="active"></button>
            <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="1"></button>
            <button type="button" data-bs-target="#heroCarousel" data-bs-slide-to="2"></button>
        </div>
        <div class="carousel-inner">
            <div class="carousel-item active">
                <img src="assets/images/Hero/Ganesh Pooja.webp" class="d-block w-100" alt="Ganesh Pooja">
                <div class="carousel-caption">
                    <h2>Ganesh Pooja Essentials</h2>
                    <p>Complete kit for auspicious beginnings</p>
                    <a href="#" class="btn btn-light btn-lg">Shop Now</a>
                </div>
            </div>
            <div class="carousel-item">
                <img src="assets/images/Hero/Lakshmi Pooja.jpg" class="d-block w-100" alt="Lakshmi Pooja">
                <div class="carousel-caption">
                    <h2>Lakshmi Pooja Kit</h2>
                    <p>Invite prosperity and abundance</p>
                    <a href="#" class="btn btn-light btn-lg">Shop Now</a>
                </div>
            </div>
            <div class="carousel-item">
                <img src="assets/images/Hero/Satyanarayan Pooja.webp" class="d-block w-100" alt="Satyanarayan Pooja">
                <div class="carousel-caption">
                    <h2>Satyanarayan Pooja Kit</h2>
                    <p>Complete samagri for monthly puja</p>
                    <a href="#" class="btn btn-light btn-lg">Shop Now</a>
                </div>
            </div>
        </div>
        <button class="carousel-control-prev" type="button" data-bs-target="#heroCarousel" data-bs-slide="prev">
            <span class="carousel-control-prev-icon"></span>
            <span class="visually-hidden">Previous</span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#heroCarousel" data-bs-slide="next">
            <span class="carousel-control-next-icon"></span>
            <span class="visually-hidden">Next</span>
        </button>
    </div>

    <!-- Key Features -->
    <section class="key-features py-5">
        <div class="container">
            <h2 class="text-center mb-5">Why Choose PoojaFestival.in?</h2>
            <div class="row g-4">
                <div class="col-md-6 col-lg-3">
                    <div class="feature-card text-center p-4">
                        <div class="feature-icon mb-3">
                            <i class="bi bi-arrow-repeat fs-1 text-primary"></i>
                        </div>
                        <h3 class="h5">One-Click Reorder</h3>
                        <p class="mb-0">Easily reorder your frequent pooja essentials with a single click. Never run out of supplies!</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="feature-card text-center p-4">
                        <div class="feature-icon mb-3">
                            <i class="bi bi-calendar-event fs-1 text-primary"></i>
                        </div>
                        <h3 class="h5">Pooja Calendar</h3>
                        <p class="mb-0">Get timely reminders and suggested items for upcoming festivals and special occasions.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="feature-card text-center p-4">
                        <div class="feature-icon mb-3">
                            <i class="bi bi-box-seam fs-1 text-primary"></i>
                        </div>
                        <h3 class="h5">Monthly Subscription</h3>
                        <p class="mb-0">Subscribe to regular pooja supplies and save up to 20% on your monthly essentials.</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3">
                    <div class="feature-card text-center p-4">
                        <div class="feature-icon mb-3">
                            <i class="bi bi-gift fs-1 text-primary"></i>
                        </div>
                        <h3 class="h5">Gift Wrapping</h3>
                        <p class="mb-0">Premium gift wrapping service available for all products. Perfect for special occasions!</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Bestsellers Section -->
    <section class="bestsellers py-5">
        <div class="container">
            <h2 class="text-center mb-4">Bestselling Pooja Kits</h2>
            <div class="row">
                <!-- Bestseller Items will be dynamically loaded -->
            </div>
        </div>
    </section>

    <!-- Festival Countdown -->
    <section class="festival-countdown py-4 bg-light">
        <div class="container text-center">
            <h3>Upcoming: Diwali 2025</h3>
            <div id="countdown" class="my-3">
                <!-- Countdown timer will be dynamically updated -->
            </div>
            <a href="#" class="btn btn-primary">Get Your Diwali Kit Now!</a>
        </div>
    </section>

    <!-- Testimonials -->
    <section class="testimonials py-5">
        <div class="container">
            <h2 class="text-center mb-4">What Our Customers Say</h2>
            <div class="row">
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body">
                            <p class="card-text">"Saved my last-minute pooja shopping!"</p>
                            <footer class="blockquote-footer">Riya, Delhi</footer>
                        </div>
                    </div>
                </div>
                <!-- More testimonials will be added dynamically -->
            </div>
        </div>
    </section>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script src="assets/js/cart.js"></script>
    <script src="assets/js/main.js"></script>
</body>
</html>