<nav class="navbar navbar-expand-lg navbar-light bg-light">
        <div class="container">
            <a class="navbar-brand" href="./index.php">PoojaFestival.in</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                <li class="nav-item">
                        <a class="nav-link" href="./index.php">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="./about-us.php">About</a>
                    </li>
                    <!-- <li class="nav-item dropdown">
                    <a class="nav-link" href="./festival-shop.php">Shop By Festival</a> -->
                        <!-- <a class="nav-link dropdown-toggle" href="festival-shop.php" id="shopByFestival" role="button" data-bs-toggle="dropdown">Shop By Festival</a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="deity-shop.php">Diwali</a></li>
                            <li><a class="dropdown-item" href="#">Navratri</a></li>
                            <li><a class="dropdown-item" href="#">Shivratri</a></li>
                        </ul> -->
                    <!-- </li> -->
                    <li class="nav-item dropdown">
                    <a class="nav-link" href="./shop.php">All Products</a>
                          <!-- <a class="nav-link dropdown-toggle" href="deity-shop.php" id="shopByDeity" role="button" data-bs-toggle="dropdown">Shop By Deity</a>
                       <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="deity-shop.php?deity=ganesh">Ganesh</a></li>
                            <li><a class="dropdown-item" href="#">Lakshmi</a></li>
                            <li><a class="dropdown-item" href="#">Hanuman</a></li>
                        </ul> -->
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="./custom-kit.php">Custom Kit Builder</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="./subscriptions.php">Monthly Subscriptions</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="./guides.php">Pooja Guides</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link position-relative" href="#" data-bs-toggle="offcanvas" data-bs-target="#cartOffcanvas">
                            <i class="bi bi-cart3 fs-5"></i>
                            <span class="cart-count position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">0</span>
                        </a>
                    </li>
                    <?php if (isset($_SESSION['user_id'])): ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="bi bi-person-circle"></i> My Account
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="profile.php"><i class="bi bi-person"></i> Profile</a></li>
                            <li><a class="dropdown-item" href="profile.php#orders"><i class="bi bi-box"></i> My Orders</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="logout.php"><i class="bi bi-box-arrow-right"></i> Logout</a></li>
                        </ul>
                    </li>
                    <?php else: ?>
                    <li class="nav-item">
                        <a class="nav-link" href="login.php">Login</a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>
<!-- Cart Offcanvas Drawer -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="cartOffcanvas" aria-labelledby="cartOffcanvasLabel">
  <div class="offcanvas-header">
    <h5 class="offcanvas-title" id="cartOffcanvasLabel">Your Cart</h5>
    <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
  </div>
  <div class="offcanvas-body">
    <div id="cartOffcanvasContent">
      <!-- Cart contents will be loaded here -->
      <div class="text-center">
        <div class="spinner-border text-primary" role="status">
          <span class="visually-hidden">Loading...</span>
        </div>
        <p class="mt-2">Loading cart...</p>
      </div>
    </div>
  </div>
</div>

<script>
// Load cart count and contents when page loads
document.addEventListener('DOMContentLoaded', function() {
    const cartOffcanvas = document.getElementById('cartOffcanvas');
    const cartContent = document.getElementById('cartOffcanvasContent');
    
    // Load initial cart count
    loadCartCount();
    
    cartOffcanvas.addEventListener('show.bs.offcanvas', function() {
        loadCartContents();
    });
    
    function loadCartCount() {
        if (typeof $ !== 'undefined') {
            $.post('cart-actions.php', {
                action: 'get'
            }).then(function(response) {
                if (response.success) {
                    updateCartCountDisplay(response.cartCount);
                }
            }).catch(function(error) {
                console.error('Error loading cart count:', error);
            });
        }
    }
    
    function updateCartCountDisplay(count) {
        const cartCountElement = document.querySelector('.cart-count');
        if (cartCountElement) {
            cartCountElement.textContent = count;
            // Show/hide badge based on count
            if (count > 0) {
                cartCountElement.style.display = 'block';
            } else {
                cartCountElement.style.display = 'none';
            }
        }
    }
    
    function loadCartContents() {
        if (typeof $ !== 'undefined') {
            $.post('cart-actions.php', {
                action: 'get'
            }).then(function(response) {
                if (response.success) {
                    displayCartContents(response.items, response.cartTotal);
                } else {
                    displayEmptyCart();
                }
            }).catch(function(error) {
                console.error('Error loading cart:', error);
                displayEmptyCart();
            });
        } else {
            displayEmptyCart();
        }
    }
    
    function displayCartContents(items, total) {
        if (items && Object.keys(items).length > 0) {
            let html = '<div class="cart-items">';
            
            Object.values(items).forEach(function(item) {
                html += `
                    <div class="card mb-3 cart-item-mini" data-product-id="${item.id}">
                        <div class="row g-0">
                            <div class="col-3">
                                <img src="assets/images/${item.image_url}" class="img-fluid rounded-start" 
                                     alt="${item.name}" style="height: 60px; object-fit: cover;"
                                     onerror="this.src='assets/images/placeholder.jpg';">
                            </div>
                            <div class="col-9">
                                <div class="card-body p-2">
                                    <h6 class="card-title mb-1">${item.name}</h6>
                                    <p class="card-text mb-1">
                                        <small class="text-muted">Qty: ${item.quantity}</small>
                                    </p>
                                    <p class="card-text mb-0">
                                        <strong>₹${(item.price * item.quantity).toFixed(2)}</strong>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                `;
            });
            
            html += `
                </div>
                <hr>
                <div class="d-flex justify-content-between mb-3">
                    <strong>Total:</strong>
                    <strong>₹${total.toFixed(2)}</strong>
                </div>
                <div class="d-grid gap-2">
                    <a href="cart.php" class="btn btn-primary">View Full Cart</a>
                    <a href="checkout.php" class="btn btn-success">Proceed to Checkout</a>
                </div>
            `;
            
            cartContent.innerHTML = html;
        } else {
            displayEmptyCart();
        }
    }
    
    function displayEmptyCart() {
        cartContent.innerHTML = `
            <div class="text-center py-4">
                <i class="bi bi-cart3 fs-1 text-muted"></i>
                <h6 class="mt-3">Your cart is empty</h6>
                <p class="text-muted">Add some products to get started!</p>
                <a href="shop.php" class="btn btn-primary">Start Shopping</a>
            </div>
        `;
    }
});
</script>