<?php
// Razorpay Configuration
// Replace these with your actual Razorpay API keys

// Test Environment (for development)
// These are sample test keys - replace with your actual test keys from Razorpay dashboard
define('RAZORPAY_TEST_KEY_ID', 'rzp_test_1DP5mmOlF5G5ag');
define('RAZORPAY_TEST_KEY_SECRET', 'thisisasamplesecretkey');

// Production Environment (for live website)
define('RAZORPAY_LIVE_KEY_ID', 'rzp_live_YOUR_LIVE_KEY_ID');
define('RAZORPAY_LIVE_KEY_SECRET', 'YOUR_LIVE_KEY_SECRET');

// Environment setting (change to 'production' for live website)
define('RAZORPAY_ENVIRONMENT', 'test'); // 'test' or 'production'

// Test mode - set to true to bypass actual API calls (for development only)
define('RAZORPAY_TEST_MODE', true); // Set to false for real API calls

// Get the appropriate keys based on environment
function getRazorpayKeys() {
    if (RAZORPAY_ENVIRONMENT === 'production') {
        return [
            'key_id' => RAZORPAY_LIVE_KEY_ID,
            'key_secret' => RAZORPAY_LIVE_KEY_SECRET
        ];
    } else {
        return [
            'key_id' => RAZORPAY_TEST_KEY_ID,
            'key_secret' => RAZORPAY_TEST_KEY_SECRET
        ];
    }
}

// Create a mock Razorpay order for testing
function createMockRazorpayOrder($amount) {
    return [
        'id' => 'order_' . time() . '_' . rand(1000, 9999),
        'entity' => 'order',
        'amount' => $amount * 100,
        'amount_paid' => 0,
        'amount_due' => $amount * 100,
        'currency' => 'INR',
        'receipt' => 'order_' . time(),
        'status' => 'created',
        'attempts' => 0,
        'notes' => [],
        'created_at' => time()
    ];
}

// Razorpay API endpoints
define('RAZORPAY_API_URL', 'https://api.razorpay.com/v1');

// Webhook secret (for payment verification)
define('RAZORPAY_WEBHOOK_SECRET', 'YOUR_WEBHOOK_SECRET');

// Currency settings
define('RAZORPAY_CURRENCY', 'INR');

// Payment methods supported
define('RAZORPAY_PAYMENT_METHODS', [
    'card' => 'Credit/Debit Cards',
    'netbanking' => 'Net Banking',
    'wallet' => 'Wallets',
    'upi' => 'UPI',
    'emi' => 'EMI'
]);

// Instructions for setup:
/*
1. Sign up for a Razorpay account at https://razorpay.com
2. Get your API keys from the Razorpay Dashboard
3. Replace the placeholder values above with your actual keys
4. For testing, use the test keys
5. For production, use the live keys and change RAZORPAY_ENVIRONMENT to 'production'
6. Set up webhooks in your Razorpay dashboard for payment verification
7. Update the webhook secret above

Test Card Details:
- Card Number: 4111 1111 1111 1111
- Expiry: Any future date
- CVV: Any 3 digits
- Name: Any name
- 3D Secure Password: 1221

Test UPI: success@razorpay

For Development:
- Set RAZORPAY_TEST_MODE to true to bypass actual API calls
- This allows testing the checkout flow without real API keys
*/
?> 