<?php
// Database configuration
// define('DB_HOST', 'localhost');
// define('DB_USER', 'root');
// define('DB_PASS', '');
// define('DB_NAME', 'pooja_festival');

define('DB_HOST', 'localhost');
define('DB_USER', 'dchsin_dchsAdmin');
define('DB_PASS', 'Admin$dchs@2025');
define('DB_NAME', 'dchsin_poojafestival');


// Create database connection
function connectDB() {
    try {
        $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
        
        // Check connection
        if ($conn->connect_error) {
            throw new Exception("Connection failed: " . $conn->connect_error);
        }
        
        // Set charset to utf8mb4
        $conn->set_charset("utf8mb4");
        
        return $conn;
    } catch (Exception $e) {
        // Log error (in production, use proper error logging)
        error_log($e->getMessage());
        return false;
    }
}

// Close database connection
function closeDB($conn) {
    if ($conn) {
        $conn->close();
    }
}

// Sanitize input data
function sanitizeInput($data) {
    $conn = connectDB();
    if ($conn) {
        $data = $conn->real_escape_string($data);
        closeDB($conn);
    }
    return htmlspecialchars(strip_tags(trim($data)));
}

// Execute query with error handling
function executeQuery($query) {
    $conn = connectDB();
    if (!$conn) {
        return false;
    }
    
    try {
        $result = $conn->query($query);
        if ($result === false) {
            throw new Exception("Query failed: " . $conn->error);
        }
        closeDB($conn);
        return $result;
    } catch (Exception $e) {
        error_log($e->getMessage());
        closeDB($conn);
        return false;
    }
}

// Get single row
function getRow($query) {
    $result = executeQuery($query);
    if ($result && $result->num_rows > 0) {
        return $result->fetch_assoc();
    }
    return false;
}

// Get multiple rows
function getRows($query) {
    $result = executeQuery($query);
    if ($result && $result->num_rows > 0) {
        $rows = array();
        while ($row = $result->fetch_assoc()) {
            $rows[] = $row;
        }
        return $rows;
    }
    return array();
}

// Insert record and return insert ID
function insertRecord($query) {
    $conn = connectDB();
    if (!$conn) {
        return false;
    }
    
    try {
        if ($conn->query($query) === true) {
            $insertId = $conn->insert_id;
            closeDB($conn);
            return $insertId;
        }
        throw new Exception("Insert failed: " . $conn->error);
    } catch (Exception $e) {
        error_log($e->getMessage());
        closeDB($conn);
        return false;
    }
}

// Update record and return affected rows
function updateRecord($query) {
    $conn = connectDB();
    if (!$conn) {
        return false;
    }
    
    try {
        if ($conn->query($query) === true) {
            $affectedRows = $conn->affected_rows;
            closeDB($conn);
            return $affectedRows;
        }
        throw new Exception("Update failed: " . $conn->error);
    } catch (Exception $e) {
        error_log($e->getMessage());
        closeDB($conn);
        return false;
    }
}

// Delete record and return affected rows
function deleteRecord($query) {
    return updateRecord($query); // Uses same logic as update
}
?>