<?php
// Site Configuration
define('SITE_NAME', 'PoojaFestival.in');
define('SITE_URL', 'http://localhost/pooja%20festival');
define('ADMIN_EMAIL', 'admin@poojafestival.in');

// Directory Paths
define('ROOT_PATH', dirname(__DIR__));
define('ASSETS_PATH', ROOT_PATH . '/assets');
define('UPLOADS_PATH', ASSETS_PATH . '/uploads');
define('IMAGES_PATH', ASSETS_PATH . '/images');

// URL Paths
define('ASSETS_URL', SITE_URL . '/assets');
define('UPLOADS_URL', ASSETS_URL . '/uploads');
define('IMAGES_URL', ASSETS_URL . '/images');

// Session Configuration
ini_set('session.cookie_lifetime', 60 * 60 * 24 * 7); // 1 week
ini_set('session.gc_maxlifetime', 60 * 60 * 24 * 7); // 1 week

// Error Reporting
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', ROOT_PATH . '/logs/error.log');

// Timezone
date_default_timezone_set('Asia/Kolkata');

// Delivery Settings
define('SAME_DAY_DELIVERY_CUTOFF', '12:00:00'); // 12 PM cutoff for same day delivery
define('SAME_DAY_DELIVERY_CHARGE', 100);
define('STANDARD_DELIVERY_CHARGE', 50);

// Payment Settings
define('RAZORPAY_KEY_ID', 'YOUR_RAZORPAY_KEY_ID'); // Replace in production
define('RAZORPAY_KEY_SECRET', 'YOUR_RAZORPAY_KEY_SECRET'); // Replace in production
define('CURRENCY', 'INR');
define('MIN_ORDER_AMOUNT', 299);

// Order Status Constants
define('ORDER_STATUS_PENDING', 'pending');
define('ORDER_STATUS_PROCESSING', 'processing');
define('ORDER_STATUS_SHIPPED', 'shipped');
define('ORDER_STATUS_DELIVERED', 'delivered');
define('ORDER_STATUS_CANCELLED', 'cancelled');

// Payment Status Constants
define('PAYMENT_STATUS_PENDING', 'pending');
define('PAYMENT_STATUS_PAID', 'paid');
define('PAYMENT_STATUS_FAILED', 'failed');

// Subscription Frequencies
define('SUBSCRIPTION_WEEKLY', 'weekly');
define('SUBSCRIPTION_MONTHLY', 'monthly');
define('SUBSCRIPTION_QUARTERLY', 'quarterly');

// Cache Settings
define('CACHE_ENABLED', true);
define('CACHE_DURATION', 3600); // 1 hour

// Pagination Settings
define('ITEMS_PER_PAGE', 12);
define('ADMIN_ITEMS_PER_PAGE', 20);

// File Upload Settings
define('MAX_FILE_SIZE', 5 * 1024 * 1024); // 5MB
define('ALLOWED_IMAGE_TYPES', ['image/jpeg', 'image/png', 'image/webp']);

// Security Settings
define('PASSWORD_MIN_LENGTH', 8);
define('LOGIN_MAX_ATTEMPTS', 5);
define('LOGIN_LOCKOUT_TIME', 15 * 60); // 15 minutes

// Email Settings
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'your-email@gmail.com'); // Replace in production
define('SMTP_PASSWORD', 'your-app-password'); // Replace in production
define('SMTP_FROM_EMAIL', 'noreply@poojafestival.in');
define('SMTP_FROM_NAME', SITE_NAME);

// Social Media Links
define('SOCIAL_FACEBOOK', 'https://facebook.com/poojafestival');
define('SOCIAL_INSTAGRAM', 'https://instagram.com/poojafestival');
define('SOCIAL_WHATSAPP', 'https://wa.me/919XXXXXXXXX'); // Replace with actual number

// Customer Support
define('SUPPORT_PHONE', '+91-XXXXXXXXXX'); // Replace with actual number
define('SUPPORT_EMAIL', 'support@poojafestival.in');
define('SUPPORT_HOURS', '9 AM to 6 PM (IST)');

// SEO Settings
define('DEFAULT_META_TITLE', 'PoojaFestival.in - Your One-Stop Shop for Pooja Essentials');
define('DEFAULT_META_DESCRIPTION', 'Buy complete pooja kits, individual items, and book pandits for all your religious ceremonies. Same-day delivery available!');
define('DEFAULT_META_KEYWORDS', 'pooja items, pooja kits, religious items, pandit booking, same day delivery');

// Custom Functions
function formatCurrency($amount) {
    return '₹' . number_format($amount, 2);
}

function isProduction() {
    return $_SERVER['SERVER_NAME'] === 'poojafestival.in';
}

function generateSlug($string) {
    return strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $string)));
}

function sanitizeFileName($fileName) {
    // Remove any path info
    $fileName = basename($fileName);
    // Replace spaces and special chars
    $fileName = preg_replace('/[^A-Za-z0-9._-]/', '-', $fileName);
    return $fileName;
}

function isValidEmail($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL);
}

function isValidPhone($phone) {
    return preg_match('/^[0-9]{10}$/', $phone);
}

function getFileExtension($fileName) {
    return strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
}

function isValidImageType($type) {
    return in_array($type, ALLOWED_IMAGE_TYPES);
}

function generateRandomString($length = 10) {
    return bin2hex(random_bytes($length));
}

function redirectTo($path) {
    header("Location: " . SITE_URL . $path);
    exit();
}

function getCurrentPageUrl() {
    return SITE_URL . $_SERVER['REQUEST_URI'];
}

function isAjaxRequest() {
    return !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && 
           strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
}

// Initialize session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>