<?php
require_once __DIR__ . '/../config/database.php';

class Product {
    private $id;
    private $category_id;
    private $name;
    private $slug;
    private $description;
    private $price;
    private $sale_price;
    private $stock;
    private $image_url;
    private $is_featured;

    // Get products with filters
    public function getProducts($category = null, $sort = 'name_asc', $search = '') {
        $query = "SELECT * FROM products WHERE 1=1";
        
        // Add category filter
        if ($category) {
            $category = (int)$category;
            $query .= " AND category_id = $category";
        }
        
        // Add search filter
        if ($search) {
            $search = sanitizeInput($search);
            $query .= " AND (name LIKE '%$search%' OR description LIKE '%$search%')";
        }
        
        // Add sorting
        switch ($sort) {
            case 'name_desc':
                $query .= " ORDER BY name DESC";
                break;
            case 'price_asc':
                $query .= " ORDER BY price ASC";
                break;
            case 'price_desc':
                $query .= " ORDER BY price DESC";
                break;
            default: // name_asc
                $query .= " ORDER BY name ASC";
        }
        
        return getRows($query);
    }

    // Get all products
    public static function getAllProducts($limit = null) {
        $query = "SELECT * FROM products ORDER BY created_at DESC";
        if ($limit) {
            $query .= " LIMIT " . (int)$limit;
        }
        return getRows($query);
    }

    // Get featured products
    public static function getFeaturedProducts($limit = 5) {
        $query = "SELECT * FROM products WHERE is_featured = 1 ORDER BY created_at DESC LIMIT " . (int)$limit;
        return getRows($query);
    }

    // Get product by ID
    public static function getProductById($id) {
        $id = (int)$id;
        $query = "SELECT * FROM products WHERE id = $id";
        error_log("Getting product by ID: $id");
        $result = getRow($query);
        error_log("Product result: " . print_r($result, true));
        return $result;
    }

    // Get products by category
    public static function getProductsByCategory($category_id) {
        $category_id = (int)$category_id;
        $query = "SELECT * FROM products WHERE category_id = $category_id ORDER BY created_at DESC";
        return getRows($query);
    }

    // Search products
    public static function searchProducts($keyword) {
        $keyword = sanitizeInput($keyword);
        $query = "SELECT * FROM products WHERE name LIKE '%$keyword%' OR description LIKE '%$keyword%'";
        return getRows($query);
    }

    // Get product materials
    public static function getProductMaterials($product_id) {
        $product_id = (int)$product_id;
        $query = "SELECT * FROM product_materials WHERE product_id = $product_id";
        return getRows($query);
    }

    // Add new product
    public static function addProduct($data) {
        $name = sanitizeInput($data['name']);
        $slug = sanitizeInput($data['slug']);
        $description = sanitizeInput($data['description']);
        $price = (float)$data['price'];
        $category_id = (int)$data['category_id'];
        $stock = (int)$data['stock'];
        $image_url = sanitizeInput($data['image_url']);
        
        $query = "INSERT INTO products (name, slug, description, price, category_id, stock, image_url) 
                  VALUES ('$name', '$slug', '$description', $price, $category_id, $stock, '$image_url')";
        
        return insertRecord($query);
    }

    // Update product
    public static function updateProduct($id, $data) {
        $id = (int)$id;
        $updates = [];

        if (isset($data['name'])) {
            $updates[] = "name = '" . sanitizeInput($data['name']) . "'";
        }
        if (isset($data['description'])) {
            $updates[] = "description = '" . sanitizeInput($data['description']) . "'";
        }
        if (isset($data['price'])) {
            $updates[] = "price = " . (float)$data['price'];
        }
        if (isset($data['stock'])) {
            $updates[] = "stock = " . (int)$data['stock'];
        }
        if (isset($data['image_url'])) {
            $updates[] = "image_url = '" . sanitizeInput($data['image_url']) . "'";
        }

        if (empty($updates)) {
            return false;
        }

        $query = "UPDATE products SET " . implode(", ", $updates) . " WHERE id = $id";
        return updateRecord($query);
    }

    // Delete product
    public static function deleteProduct($id) {
        $id = (int)$id;
        $query = "DELETE FROM products WHERE id = $id";
        return deleteRecord($query);
    }

    // Check if product exists
    public static function productExists($id) {
        $id = (int)$id;
        $query = "SELECT id FROM products WHERE id = $id";
        $result = getRow($query);
        return !empty($result);
    }

    // Update stock
    public static function updateStock($id, $quantity) {
        $id = (int)$id;
        $quantity = (int)$quantity;
        $query = "UPDATE products SET stock = stock + $quantity WHERE id = $id";
        return updateRecord($query);
    }

    // Get product reviews
    public static function getProductReviews($product_id) {
        $product_id = (int)$product_id;
        $query = "SELECT r.*, u.name as user_name 
                  FROM reviews r 
                  JOIN users u ON r.user_id = u.id 
                  WHERE r.product_id = $product_id 
                  ORDER BY r.created_at DESC";
        return getRows($query);
    }

    // Add product review
    public static function addReview($product_id, $user_id, $rating, $comment) {
        $product_id = (int)$product_id;
        $user_id = (int)$user_id;
        $rating = (int)$rating;
        $comment = sanitizeInput($comment);

        $query = "INSERT INTO reviews (product_id, user_id, rating, comment) 
                  VALUES ($product_id, $user_id, $rating, '$comment')";
        return insertRecord($query);
    }

    // Get average rating
    public static function getAverageRating($product_id) {
        $product_id = (int)$product_id;
        $query = "SELECT AVG(rating) as avg_rating FROM reviews WHERE product_id = $product_id";
        $result = getRow($query);
        return $result ? round($result['avg_rating'], 1) : 0;
    }
}
?>