<?php
require_once __DIR__ . '/../config/database.php';

class CustomKit {
    private $id;
    private $template_id;
    private $name;
    private $description;
    private $base_price;

    // Get all kit templates
    public static function getAllTemplates() {
        $query = "SELECT * FROM custom_kit_templates ORDER BY name";
        return getRows($query);
    }

    // Get template by ID
    public static function getTemplateById($id) {
        $id = (int)$id;
        $query = "SELECT * FROM custom_kit_templates WHERE id = $id";
        return getRow($query);
    }

    // Get template items
    public static function getTemplateItems($template_id) {
        $template_id = (int)$template_id;
        $query = "SELECT * FROM custom_kit_items WHERE template_id = $template_id ORDER BY name";
        return getRows($query);
    }

    // Create new template
    public static function createTemplate($data) {
        $name = sanitizeInput($data['name']);
        $description = sanitizeInput($data['description']);
        $base_price = (float)$data['base_price'];

        $query = "INSERT INTO custom_kit_templates (name, description, base_price) 
                  VALUES ('$name', '$description', $base_price)";
        
        $template_id = insertRecord($query);
        
        if ($template_id && isset($data['items'])) {
            foreach ($data['items'] as $item) {
                self::addTemplateItem($template_id, $item);
            }
        }
        
        return $template_id;
    }

    // Add template item
    private static function addTemplateItem($template_id, $item) {
        $template_id = (int)$template_id;
        $name = sanitizeInput($item['name']);
        $price = (float)$item['price'];
        $is_optional = isset($item['is_optional']) ? (int)$item['is_optional'] : 0;

        $query = "INSERT INTO custom_kit_items (template_id, name, price, is_optional) 
                  VALUES ($template_id, '$name', $price, $is_optional)";
        
        return insertRecord($query);
    }

    // Update template
    public static function updateTemplate($id, $data) {
        $id = (int)$id;
        $updates = [];

        if (isset($data['name'])) {
            $updates[] = "name = '" . sanitizeInput($data['name']) . "'";
        }
        if (isset($data['description'])) {
            $updates[] = "description = '" . sanitizeInput($data['description']) . "'";
        }
        if (isset($data['base_price'])) {
            $updates[] = "base_price = " . (float)$data['base_price'];
        }

        if (empty($updates)) {
            return false;
        }

        $query = "UPDATE custom_kit_templates SET " . implode(", ", $updates) . " WHERE id = $id";
        return updateRecord($query);
    }

    // Delete template
    public static function deleteTemplate($id) {
        $id = (int)$id;
        $query = "DELETE FROM custom_kit_templates WHERE id = $id";
        return deleteRecord($query);
    }

    // Calculate kit price
    public static function calculateKitPrice($template_id, $selected_items) {
        $template = self::getTemplateById($template_id);
        if (!$template) {
            return 0;
        }

        $total = $template['base_price'];

        // Get all items for this template
        $items = self::getTemplateItems($template_id);
        $items_by_id = array();
        foreach ($items as $item) {
            $items_by_id[$item['id']] = $item;
        }

        // Add price for selected items
        foreach ($selected_items as $item_id) {
            if (isset($items_by_id[$item_id])) {
                $total += $items_by_id[$item_id]['price'];
            }
        }

        return $total;
    }

    // Get popular kit combinations
    public static function getPopularCombinations($limit = 5) {
        // This would typically be based on order history
        // For now, returning predefined popular combinations
        return [
            [
                'name' => 'Complete Daily Pooja Kit',
                'items' => ['Diya', 'Incense Sticks', 'Flowers', 'Bell', 'Kumkum'],
                'price' => 999
            ],
            [
                'name' => 'Basic Meditation Kit',
                'items' => ['Incense Sticks', 'Meditation Mat', 'Bell'],
                'price' => 599
            ],
            [
                'name' => 'Festival Special Kit',
                'items' => ['Large Diya', 'Premium Incense', 'Flowers', 'Sweets', 'Decorative Items'],
                'price' => 1499
            ]
        ];
    }

    // Get items by pooja type
    public static function getItemsByPoojaType($pooja_type) {
        $pooja_type = sanitizeInput($pooja_type);
        $query = "SELECT i.* 
                  FROM custom_kit_items i 
                  JOIN custom_kit_templates t ON i.template_id = t.id 
                  WHERE t.name LIKE '%$pooja_type%'";
        return getRows($query);
    }

    // Get recommended items
    public static function getRecommendedItems($template_id) {
        $template_id = (int)$template_id;
        $query = "SELECT i.* 
                  FROM custom_kit_items i 
                  WHERE i.template_id = $template_id 
                  AND i.is_optional = 1 
                  ORDER BY RAND() 
                  LIMIT 3";
        return getRows($query);
    }

    // Save custom kit configuration
    public static function saveCustomKit($user_id, $template_id, $selected_items, $name = null) {
        $user_id = (int)$user_id;
        $template_id = (int)$template_id;
        $name = $name ? sanitizeInput($name) : 'Custom Kit ' . date('Y-m-d H:i:s');
        $items_json = json_encode($selected_items);

        $query = "INSERT INTO saved_custom_kits (user_id, template_id, name, selected_items) 
                  VALUES ($user_id, $template_id, '$name', '$items_json')";
        
        return insertRecord($query);
    }

    // Get saved custom kits
    public static function getSavedKits($user_id) {
        $user_id = (int)$user_id;
        $query = "SELECT sk.*, t.name as template_name 
                  FROM saved_custom_kits sk 
                  JOIN custom_kit_templates t ON sk.template_id = t.id 
                  WHERE sk.user_id = $user_id 
                  ORDER BY sk.created_at DESC";
        return getRows($query);
    }
}
?>