<?php
require_once __DIR__ . '/classes/Cart.php';
$cart = new Cart();
$cartItems = $cart->getItems();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shopping Cart - PoojaFestival.in</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <!-- Navigation -->
    <?php include 'includes/nav.php'; ?>

    <!-- Cart Section -->
    <div class="container my-5">
        <h1 class="mb-4">Shopping Cart</h1>
        
        <?php if (isset($_GET['debug']) && $_GET['debug'] == '1'): ?>
        <div class="alert alert-info">
            <h5>Debug Information:</h5>
            <p>Cart Items: <?php echo count($cartItems); ?></p>
            <?php foreach ($cartItems as $item): ?>
            <div class="mb-2">
                <strong><?php echo htmlspecialchars($item['name']); ?></strong><br>
                Image URL: <?php echo htmlspecialchars($item['image_url']); ?><br>
                Full Path: assets/images/<?php echo htmlspecialchars($item['image_url']); ?><br>
                File Exists: <?php echo file_exists('assets/images/' . $item['image_url']) ? 'Yes' : 'No'; ?>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
        
        <?php if (empty($cartItems)): ?>
        <div class="alert alert-info">
            Your cart is empty. <a href="shop.php" class="alert-link">Continue shopping</a>
        </div>
        <?php else: ?>

        <div class="row">
            <div class="col-lg-8">
                <!-- Cart Items -->
                <div class="cart-items">
                    <?php foreach ($cartItems as $item): ?>
                    <div class="card mb-3 cart-item" data-product-id="<?php echo $item['id']; ?>">
                        <div class="row g-0">
                            <div class="col-md-2">
                                <?php 
                                $imagePath = 'assets/images/' . htmlspecialchars($item['image_url']);
                                $imageExists = file_exists($imagePath);
                                ?>
                                <img src="<?php echo $imagePath; ?>" 
                                     class="img-fluid rounded-start" 
                                     alt="<?php echo htmlspecialchars($item['name']); ?>"
                                     onerror="this.src='assets/images/placeholder.jpg'; this.onerror=null;"
                                     style="<?php echo !$imageExists ? 'border: 2px solid #ffc107;' : ''; ?>">
                                <?php if (!$imageExists): ?>
                                    <small class="text-warning d-block mt-1">Image not found</small>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-10">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <h5 class="card-title"><?php echo htmlspecialchars($item['name']); ?></h5>
                                        <button type="button" class="btn-close remove-item"></button>
                                    </div>
                                    <div class="d-flex justify-content-between align-items-center mt-3">
                                        <div class="quantity-controls">
                                            <button class="btn btn-sm btn-outline-secondary decrease-quantity">-</button>
                                            <input type="number" class="form-control form-control-sm d-inline-block mx-2 quantity-input" 
                                                   style="width: 60px" value="<?php echo $item['quantity']; ?>" 
                                                   min="1" max="99">
                                            <button class="btn btn-sm btn-outline-secondary increase-quantity">+</button>
                                        </div>
                                        <div class="price">
                                            ₹<?php echo number_format($item['price'] * $item['quantity'], 2); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>

                <!-- Continue Shopping -->
                <div class="d-flex justify-content-between mt-4">
                    <a href="shop.php" class="btn btn-outline-primary">Continue Shopping</a>
                    <button class="btn btn-outline-danger clear-cart">Clear Cart</button>
                </div>
            </div>

            <div class="col-lg-4">
                <!-- Cart Summary -->
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Cart Summary</h5>
                        <div class="d-flex justify-content-between mb-3">
                            <span>Subtotal:</span>
                            <span class="cart-subtotal">₹<?php echo number_format($cart->getTotal(), 2); ?></span>
                        </div>
                        <div class="d-flex justify-content-between mb-3">
                            <span>Shipping:</span>
                            <span>Free</span>
                        </div>
                        <hr>
                        <div class="d-flex justify-content-between mb-3">
                            <strong>Total:</strong>
                            <strong class="cart-total">₹<?php echo number_format($cart->getTotal(), 2); ?></strong>
                        </div>
                        <a href="checkout.php" class="btn btn-primary w-100">Proceed to Checkout</a>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Footer -->
    <?php include 'includes/footer.php'; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
    $(document).ready(function() {
        // Update quantity
        function updateQuantity(productId, quantity) {
            $.post('cart-actions.php', {
                action: 'update',
                product_id: productId,
                quantity: quantity
            }, function(response) {
                if (response.success) {
                    updateCartDisplay(response);
                }
            });
        }

        // Remove item
        $('.remove-item').click(function() {
            const cartItem = $(this).closest('.cart-item');
            const productId = cartItem.data('product-id');
            
            $.post('cart-actions.php', {
                action: 'remove',
                product_id: productId
            }, function(response) {
                if (response.success) {
                    cartItem.remove();
                    updateCartDisplay(response);
                    if (response.cartCount === 0) {
                        location.reload();
                    }
                }
            });
        });

        // Clear cart
        $('.clear-cart').click(function() {
            if (confirm('Are you sure you want to clear your cart?')) {
                $.post('cart-actions.php', {
                    action: 'clear'
                }, function(response) {
                    if (response.success) {
                        location.reload();
                    }
                });
            }
        });

        // Quantity controls
        $('.decrease-quantity').click(function() {
            const input = $(this).siblings('.quantity-input');
            const newVal = parseInt(input.val()) - 1;
            if (newVal >= 1) {
                input.val(newVal).trigger('change');
            }
        });

        $('.increase-quantity').click(function() {
            const input = $(this).siblings('.quantity-input');
            const newVal = parseInt(input.val()) + 1;
            if (newVal <= 99) {
                input.val(newVal).trigger('change');
            }
        });

        $('.quantity-input').change(function() {
            const cartItem = $(this).closest('.cart-item');
            const productId = cartItem.data('product-id');
            const quantity = parseInt($(this).val());
            
            if (quantity >= 1 && quantity <= 99) {
                updateQuantity(productId, quantity);
            }
        });

        // Update cart display
        function updateCartDisplay(response) {
            $('.cart-subtotal, .cart-total').text('₹' + response.cartTotal.toFixed(2));
            if (response.cartCount === 0) {
                location.reload();
            }
        }
    });
    </script>
</body>
</html>