document.addEventListener('DOMContentLoaded', function() {
    // Initialize Festival Countdown
    initializeFestivalCountdown();

    // Load Bestsellers
    loadBestsellers();

    // Load Testimonials
    loadTestimonials();
});

// Festival Countdown Timer
function initializeFestivalCountdown() {
    const countdownElement = document.getElementById('countdown');
    if (!countdownElement) return;

    // Set Diwali 2024 date (example date - update as needed)
    const festivalDate = new Date('2024-11-01T00:00:00');

    function updateCountdown() {
        const now = new Date();
        const difference = festivalDate - now;

        if (difference > 0) {
            const days = Math.floor(difference / (1000 * 60 * 60 * 24));
            const hours = Math.floor((difference % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            const minutes = Math.floor((difference % (1000 * 60 * 60)) / (1000 * 60));

            countdownElement.innerHTML = `
                <div class="d-flex justify-content-center gap-3">
                    <div class="text-center">
                        <h4>${days}</h4>
                        <small>Days</small>
                    </div>
                    <div class="text-center">
                        <h4>${hours}</h4>
                        <small>Hours</small>
                    </div>
                    <div class="text-center">
                        <h4>${minutes}</h4>
                        <small>Minutes</small>
                    </div>
                </div>
            `;
        } else {
            countdownElement.innerHTML = '<p>Festival has begun!</p>';
        }
    }

    // Update countdown every minute
    updateCountdown();
    setInterval(updateCountdown, 60000);
}

// Load Bestselling Products
function loadBestsellers() {
    const bestsellersContainer = document.querySelector('.bestsellers .row');
    if (!bestsellersContainer) return;

    // Example bestseller products (in real implementation, this would come from your backend)
    const bestsellers = [
        {
            name: 'Diwali Complete Kit',
            price: 2499,
            image: 'assets/images/diwali-kit.svg',
            description: 'Everything you need for Diwali Pooja'
        },
        {
            name: 'Satyanarayan Kit',
            price: 1999,
            image: 'assets/images/satyanarayan-kit.svg',
            description: 'Complete Satyanarayan Pooja Samagri'
        },
        {
            name: 'Daily Pooja Kit',
            price: 999,
            image: 'assets/images/daily-kit.svg',
            description: 'Essential items for daily worship'
        },
        {
            name: 'Ganesh Chaturthi Kit',
            price: 1499,
            image: 'assets/images/ganesh-kit.svg',
            description: 'Special Ganesh Chaturthi celebration kit'
        },
        {
            name: 'Navratri Special Kit',
            price: 2999,
            image: 'assets/images/navratri-kit.svg',
            description: 'Complete 9-day Navratri celebration kit'
        }
    ];

    bestsellersContainer.innerHTML = bestsellers.map((product, idx) => `
        <div class="col-md-4 mb-4">
            <div class="card h-100">
                <img src="${product.image}" class="card-img-top p-3" alt="${product.name}">
                <div class="card-body">
                    <h5 class="card-title">${product.name}</h5>
                    <p class="card-text">${product.description}</p>
                    <div class="d-flex justify-content-between align-items-center">
                        <span class="h5 mb-0">₹${product.price}</span>
                        <input type="number" class="form-control d-inline-block quantity-input me-2" value="1" min="1" max="99" style="width:70px;">
                        <button class="btn btn-success add-to-cart" data-product-id="${idx+1}" data-product-name="${product.name}">Add to Cart</button>
                    </div>
                </div>
            </div>
        </div>
    `).join('');

    // Add to Cart button handler for demo (replace with real product IDs in production)
    document.querySelectorAll('.add-to-cart').forEach(btn => {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            const productId = this.getAttribute('data-product-id');
            const quantity = this.parentElement.querySelector('.quantity-input').value || 1;
            const card = this.closest('.card');
            const originalBtnText = this.textContent;
            if (window.ShoppingCart && ShoppingCart.addToCart) {
                ShoppingCart.addToCart(productId, quantity).then(response => {
                    if (response.success) {
                        // Visual feedback: highlight card and button
                        card.classList.add('border-success', 'shadow-lg');
                        this.classList.remove('btn-success');
                        this.classList.add('btn-secondary');
                        this.textContent = 'Added!';
                        this.disabled = true;
                        setTimeout(() => {
                            card.classList.remove('border-success', 'shadow-lg');
                            this.classList.remove('btn-secondary');
                            this.classList.add('btn-success');
                            this.textContent = originalBtnText;
                            this.disabled = false;
                        }, 2000);
                        // Open cart drawer
                        if (window.bootstrap && document.getElementById('cartOffcanvas')) {
                            var cartOffcanvas = new bootstrap.Offcanvas(document.getElementById('cartOffcanvas'));
                            cartOffcanvas.show();
                        }
                    } else {
                        ShoppingCart.showNotification('Failed to add product to cart.', 'danger');
                    }
                });
            } else {
                // Demo fallback
                card.classList.add('border-success', 'shadow-lg');
                this.classList.remove('btn-success');
                this.classList.add('btn-secondary');
                this.textContent = 'Added!';
                this.disabled = true;
                setTimeout(() => {
                    card.classList.remove('border-success', 'shadow-lg');
                    this.classList.remove('btn-secondary');
                    this.classList.add('btn-success');
                    this.textContent = originalBtnText;
                    this.disabled = false;
                }, 2000);
                alert('Add to cart: ' + this.getAttribute('data-product-name') + ' x' + quantity);
            }
        });
    });
}

// Load Customer Testimonials
function loadTestimonials() {
    const testimonialsContainer = document.querySelector('.testimonials .row');
    if (!testimonialsContainer) return;

    // Example testimonials (in real implementation, this would come from your backend)
    const testimonials = [
        {
            text: 'Saved my last-minute pooja shopping!',
            author: 'Riya, Delhi'
        },
        {
            text: 'The custom kit builder is amazing. Got exactly what I needed.',
            author: 'Amit, Mumbai'
        },
        {
            text: 'Great quality products and timely delivery.',
            author: 'Priya, Bangalore'
        }
    ];

    testimonialsContainer.innerHTML = testimonials.map(testimonial => `
        <div class="col-md-4 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <p class="card-text">${testimonial.text}</p>
                    <footer class="blockquote-footer">${testimonial.author}</footer>
                </div>
            </div>
        </div>
    `).join('');
}