<?php
require_once '../config/database.php';
require_once '../classes/Order.php';

header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$order_id = isset($data['order_id']) ? (int)$data['order_id'] : 0;
$status = isset($data['status']) ? sanitizeInput($data['status']) : '';

if (!$order_id || !$status) {
    echo json_encode(['success' => false, 'error' => 'Missing order_id or status']);
    exit;
}

$updated = Order::updateOrderStatus($order_id, $status);

if ($updated) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'error' => 'Failed to update order status']);
} 