<?php
require_once '../config/database.php';
session_start();

header('Content-Type: application/json');
$data = json_decode(file_get_contents('php://input'), true);

$email = isset($data['email']) ? sanitizeInput($data['email']) : '';
$password = isset($data['password']) ? $data['password'] : '';
$role = isset($data['role']) ? $data['role'] : 'customer';

if (!$email || !$password) {
    echo json_encode(['success' => false, 'error' => 'Email and password required']);
    exit;
}

if ($role === 'admin') {
    // Hardcoded admin credentials (change as needed)
    $admin_email = 'admin@poojafestival.in';
    $admin_hash = password_hash('admin123', PASSWORD_DEFAULT);
    if ($email === $admin_email && password_verify($password, $admin_hash)) {
        $_SESSION['user_role'] = 'admin';
        $_SESSION['user_email'] = $email;
        echo json_encode(['success' => true, 'role' => 'admin']);
        exit;
    } else {
        echo json_encode(['success' => false, 'error' => 'Invalid admin credentials']);
        exit;
    }
} else {
    // Customer login
    $query = "SELECT * FROM users WHERE email = '$email' LIMIT 1";
    $user = getRow($query);
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_role'] = 'customer';
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_email'] = $user['email'];
        $_SESSION['user_name'] = $user['name'];
        echo json_encode(['success' => true, 'role' => 'customer']);
        exit;
    } else {
        echo json_encode(['success' => false, 'error' => 'Invalid email or password']);
        exit;
    }
} 