<?php
require_once '../config/database.php';
require_once '../classes/Order.php';

header('Content-Type: application/json');

// Get all orders with user info
$query = "SELECT o.*, u.name as user_name, u.email, u.phone, u.address 
          FROM orders o 
          JOIN users u ON o.user_id = u.id 
          ORDER BY o.created_at DESC";
$orders = getRows($query);

foreach ($orders as &$order) {
    $order['items'] = Order::getOrderItems($order['id']);
    // Check for Custom Pooja Kit item
    foreach ($order['items'] as $item) {
        if (strtolower($item['name']) === 'custom pooja kit') {
            $customKitQuery = "SELECT materials_json FROM custom_kit_orders WHERE order_id = {$order['id']} LIMIT 1";
            $customKit = getRow($customKitQuery);
            $order['custom_kit_materials'] = $customKit ? json_decode($customKit['materials_json'], true) : [];
            break;
        }
    }
}

echo json_encode($orders); 