# PoojaFestival.in E-Commerce Website

A comprehensive e-commerce platform for pooja items and services, built with PHP and MySQL.

## Features

- **Product Catalog**
  - Pre-packaged pooja kits
  - Individual pooja items
  - Festival-specific collections
  - Deity-specific items

- **Custom Kit Builder**
  - Interactive tool to create personalized pooja kits
  - Step-by-step selection process
  - Recommended combinations
  - Save favorite configurations

- **User Management**
  - User registration and authentication
  - Order history
  - Saved addresses
  - Custom kit preferences

- **Shopping Experience**
  - Easy navigation by festival/deity
  - Advanced search functionality
  - Same-day delivery option
  - Secure checkout process

- **Payment Integration**
  - Razorpay payment gateway
  - Multiple payment options
  - Secure transaction handling

## Technical Stack

- **Backend**: PHP (Custom Framework)
- **Database**: MySQL
- **Frontend**: HTML5, CSS3, JavaScript
- **Payment Gateway**: Razorpay
- **CSS Framework**: Bootstrap 5

## Project Structure

```
pooja festival/
├── assets/
│   ├── css/
│   ├── js/
│   └── images/
├── classes/
│   ├── User.php
│   ├── Product.php
│   ├── Order.php
│   ├── CustomKit.php
│   └── Payment.php
├── config/
│   ├── config.php
│   └── database.php
├── database/
│   └── schema.sql
└── index.php
```

## Setup Instructions

1. **Prerequisites**
   - XAMPP/WAMP/LAMP server
   - PHP 7.4 or higher
   - MySQL 5.7 or higher
   - Composer (for dependencies)

2. **Database Setup**
   - Create a new database named 'pooja_festival'
   - Import the schema from `database/schema.sql`

3. **Configuration**
   - Copy `config/config.php.example` to `config/config.php`
   - Update database credentials in `config/database.php`
   - Set up Razorpay API keys in `config/config.php`

4. **Installation**
   ```bash
   # Clone the repository
   git clone [repository-url]

   # Navigate to project directory
   cd pooja-festival

   # Install dependencies
   composer install

   # Set permissions
   chmod 755 -R assets/uploads/
   ```

5. **Running the Application**
   - Access the website through your local server
   - Default URL: `http://localhost/pooja festival/`

## Development Guidelines

1. **Coding Standards**
   - Follow PSR-4 autoloading standards
   - Use meaningful variable and function names
   - Add comments for complex logic

2. **Security Measures**
   - Sanitize all user inputs
   - Use prepared statements for queries
   - Implement CSRF protection
   - Secure file uploads

3. **Performance Optimization**
   - Minimize database queries
   - Optimize images
   - Implement caching where possible

## Testing

- Unit tests for core functionality
- Integration tests for payment processing
- User acceptance testing for UI/UX

## Deployment

1. **Production Server Requirements**
   - PHP 7.4+
   - MySQL 5.7+
   - SSL Certificate
   - Sufficient storage for uploads

2. **Deployment Steps**
   - Update configuration for production
   - Set up SSL certificate
   - Configure error logging
   - Set up backup system

## Maintenance

- Regular security updates
- Database optimization
- Performance monitoring
- Regular backups

## Support

For technical support or queries:
- Email: support@poojafestival.in
- Phone: [Support Phone Number]

## Contributing

1. Fork the repository
2. Create a feature branch
3. Commit your changes
4. Push to the branch
5. Create a Pull Request

## License

This project is proprietary and confidential.
Unauthorized copying or distribution is prohibited.

## Authors

- Development Team - PoojaFestival.in

## Acknowledgments

- Bootstrap Team
- Razorpay Team
- Open source community