<?php
require_once '../includes/auth.php';
require_once '../config/db.php';

// Initialize variables
$error = '';
$success = '';

// Get classes for dropdown
$class_sql = "SELECT * FROM classes ORDER BY class_name";
$classes = $conn->query($class_sql)->fetch_all(MYSQLI_ASSOC);

// Process form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate and sanitize input
  $first_name = htmlspecialchars($_POST['first_name'] ?? '', ENT_QUOTES, 'UTF-8');
    $last_name = htmlspecialchars($_POST['last_name'] ?? '', ENT_QUOTES, 'UTF-8');
    $class_id = filter_input(INPUT_POST, 'class_id', FILTER_VALIDATE_INT);
    $academic_year = htmlspecialchars($_POST['academic_year'] ?? '', ENT_QUOTES, 'UTF-8');
    $admission_date = htmlspecialchars($_POST['admission_date'] ?? '', ENT_QUOTES, 'UTF-8');
    $contact_number = htmlspecialchars($_POST['contact_number'] ?? '', ENT_QUOTES, 'UTF-8');
    $parent_name = htmlspecialchars($_POST['parent_name'] ?? '', ENT_QUOTES, 'UTF-8');
    $address = htmlspecialchars($_POST['address'] ?? '', ENT_QUOTES, 'UTF-8');
    
    
    // Validate required fields
    if (empty($first_name) || empty($last_name) || empty($class_id) || empty($academic_year) || empty($admission_date)) {
        $error = "Please fill in all required fields.";
    } else {
        // Generate admission number
        $admission_number = generateAdmissionNumber($class_id, $academic_year);
        
        // Insert student data
        $sql = "INSERT INTO students (
            admission_number, first_name, last_name, class_id, 
            academic_year, admission_date, contact_number, 
            parent_name, address, status
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, 'active')";
        
        $stmt = $conn->prepare($sql);
        $stmt->bind_param(
            "sssssssss", 
            $admission_number, $first_name, $last_name, $class_id,
            $academic_year, $admission_date, $contact_number,
            $parent_name, $address
        );
        
        if ($stmt->execute()) {
            $success = "Student added successfully!";
            // Clear form data
            $_POST = array();
        } else {
            $error = "Failed to add student. Please try again.";
        }
    }
}

// Function to generate admission number
function generateAdmissionNumber($class_id, $academic_year) {
    global $conn;
    
    // Get class code
    $class_sql = "SELECT class_name FROM classes WHERE class_id = ?";
    $stmt = $conn->prepare($class_sql);
    $stmt->bind_param("i", $class_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $class = $result->fetch_assoc();
    
    // Get last admission number for this class
    $last_sql = "SELECT admission_number FROM students 
                 WHERE class_id = ? AND academic_year = ? 
                 ORDER BY admission_number DESC LIMIT 1";
    $stmt = $conn->prepare($last_sql);
    $stmt->bind_param("is", $class_id, $academic_year);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $year = substr($academic_year, 0, 4);
    $class_code = substr($class['class_name'], 0, 1);
    
    // if ($result->num_rows > 0) {
    //     $last = $result->fetch_assoc();
    //     $last_num = substr($last['admission_number'], -3);
    //     $new_num = str_pad($last_num + 1, 3, '0', STR_PAD_LEFT);
    // } else {
    //     $new_num = '001';
    // }
    date_default_timezone_set('Asia/Kolkata');
    $new_num = date('YmdHis'); // Will now reflect Kolkata time
    
    return $year . $class_code . $new_num;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <?php include '../includes/header-internal.php'; ?>
    <title>Add New Student</title>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Add New Student</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <a href="students.php" class="btn btn-sm btn-outline-secondary">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                    </div>
                </div>

                <?php if ($error): ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <?php if ($success): ?>
                    <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-body">
                        <form method="post" class="needs-validation" novalidate>
                            <div class="row">
                                <div class="col-md-6">
                                    <h5 class="mb-3">Personal Information</h5>
                                    
                                    <div class="mb-3">
                                        <label for="first_name" class="form-label">First Name *</label>
                                        <input type="text" class="form-control" id="first_name" name="first_name" 
                                               value="<?php echo isset($_POST['first_name']) ? htmlspecialchars($_POST['first_name']) : ''; ?>" required>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="last_name" class="form-label">Last Name *</label>
                                        <input type="text" class="form-control" id="last_name" name="last_name" 
                                               value="<?php echo isset($_POST['last_name']) ? htmlspecialchars($_POST['last_name']) : ''; ?>" required>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="class_id" class="form-label">Class *</label>
                                        <select class="form-select" id="class_id" name="class_id" required>
                                            <option value="">Select Class</option>
                                            <?php foreach ($classes as $class): ?>
                                                <option value="<?php echo $class['class_id']; ?>"
                                                        <?php echo (isset($_POST['class_id']) && $_POST['class_id'] == $class['class_id']) ? 'selected' : ''; ?>>
                                                    <?php echo htmlspecialchars($class['class_name']); ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="academic_year" class="form-label">Academic Year *</label>
                                        <select class="form-select" id="academic_year" name="academic_year" required>
                                            <option value="">Select Academic Year</option>
                                            <?php
                                            $current_year = date('Y');
                                            for ($i = 0; $i < 3; $i++) {
                                                $year = $current_year - $i;
                                                $academic_year = $year . '-' . ($year + 1);
                                                $selected = (isset($_POST['academic_year']) && $_POST['academic_year'] == $academic_year) ? 'selected' : '';
                                                echo "<option value='$academic_year' $selected>$academic_year</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="admission_date" class="form-label">Admission Date *</label>
                                        <input type="date" class="form-control" id="admission_date" name="admission_date" 
                                               value="<?php echo isset($_POST['admission_date']) ? htmlspecialchars($_POST['admission_date']) : ''; ?>" required>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <h5 class="mb-3">Contact Information</h5>
                                    
                                    <div class="mb-3">
                                        <label for="contact_number" class="form-label">Contact Number</label>
                                        <input type="tel" class="form-control" id="contact_number" name="contact_number" 
                                               value="<?php echo isset($_POST['contact_number']) ? htmlspecialchars($_POST['contact_number']) : ''; ?>">
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="parent_name" class="form-label">Parent/Guardian Name</label>
                                        <input type="text" class="form-control" id="parent_name" name="parent_name" 
                                               value="<?php echo isset($_POST['parent_name']) ? htmlspecialchars($_POST['parent_name']) : ''; ?>">
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="address" class="form-label">Address</label>
                                        <textarea class="form-control" id="address" name="address" rows="3"><?php echo isset($_POST['address']) ? htmlspecialchars($_POST['address']) : ''; ?></textarea>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="mt-4">
                                <button type="submit" class="btn btn-primary">Add Student</button>
                                <a href="students.php" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <?php include '../includes/footer.php'; ?>
    
    <script>
    // Form validation
    (function () {
        'use strict'
        var forms = document.querySelectorAll('.needs-validation')
        Array.prototype.slice.call(forms)
            .forEach(function (form) {
                form.addEventListener('submit', function (event) {
                    if (!form.checkValidity()) {
                        event.preventDefault()
                        event.stopPropagation()
                    }
                    form.classList.add('was-validated')
                }, false)
            })
    })()
    </script>
</body>
</html> 