<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../config/db.php';

// Set page title
$pageTitle = "Reports";

// Get current academic year
$currentYear = date('Y') . '-' . (date('Y') + 1);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <?php include '../includes/header-internal.php'; ?>
    <style>
        .report-card {
            transition: transform 0.3s;
        }
        .report-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
          
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Reports</h1>
                </div>
                
                <div class="row">
                    <!-- Collection Summary Report -->
                    <div class="col-md-4 mb-4">
                        <div class="card report-card h-100">
                            <div class="card-body">
                                <h5 class="card-title">Collection Summary</h5>
                                <p class="card-text">View fee collection summary by date range, class, or payment mode.</p>
                                <a href="collection_summary.php" class="btn btn-primary">Generate Report</a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Defaulters Report -->
                    <div class="col-md-4 mb-4">
                        <div class="card report-card h-100">
                            <div class="card-body">
                                <h5 class="card-title">Fee Defaulters</h5>
                                <p class="card-text">List of students with outstanding fees for the current academic year.</p>
                                <a href="defaulters.php?year=<?= $currentYear ?>" class="btn btn-danger">Generate Report</a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Class-wise Collection -->
                    <div class="col-md-4 mb-4">
                        <div class="card report-card h-100">
                            <div class="card-body">
                                <h5 class="card-title">Class-wise Collection</h5>
                                <p class="card-text">Fee collection analysis by class and section.</p>
                                <a href="classwise_collection.php" class="btn btn-success">Generate Report</a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Section-wise Collection -->
                    <div class="col-md-4 mb-4">
                        <div class="card report-card h-100">
                            <div class="card-body">
                                <h5 class="card-title">Section-wise Collection</h5>
                                <p class="card-text">Fee collection analysis by section with date filtering.</p>
                                <a href="sectionwise_collection.php" class="btn btn-primary">Generate Report</a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Payment Mode Analysis -->
                    <div class="col-md-4 mb-4">
                        <div class="card report-card h-100">
                            <div class="card-body">
                                <h5 class="card-title">Payment Mode Analysis</h5>
                                <p class="card-text">Breakdown of payments by mode (Cash, Cheque, Online etc.)</p>
                                <a href="payment_mode_analysis.php" class="btn btn-info">Generate Report</a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Student Fee Statement -->
                    <div class="col-md-4 mb-4">
                        <div class="card report-card h-100">
                            <div class="card-body">
                                <h5 class="card-title">Student Fee Statement</h5>
                                <p class="card-text">Detailed fee statement for individual students.</p>
                                <a href="student_statement.php" class="btn btn-warning">Generate Report</a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Annual Report -->
                    <div class="col-md-4 mb-4">
                        <div class="card report-card h-100">
                            <div class="card-body">
                                <h5 class="card-title">Annual Financial Report</h5>
                                <p class="card-text">Comprehensive annual financial report for the school.</p>
                                <a href="annual_report.php" class="btn btn-secondary">Generate Report</a>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <?php include '../includes/footer.php'; ?>
</body>
</html>