<?php 
// In your receipt generation script:
$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage();

// School header
$pdf->SchoolHeader('ABC Public School', '123 Education Road, Mumbai - 400001', '022-12345678', 'info@abcschool.edu');

// Receipt title
$pdf->FeeReceiptTitle('FEE RECEIPT');

// Student details
$pdf->StudentDetails([
    'name' => 'Aarav Sharma',
    'admission_no' => '2023N001',
    'class' => 'Nursery'
]);

// Payment details
$pdf->PaymentDetails([
    'receipt_no' => 'RCPT-20230601-001',
    'date' => date('d/m/Y'),
    'amount' => 7000.00,
    'mode' => 'Online Transfer',
    'details' => 'UPI123456789'
]);

// Fee breakdown
$pdf->FeeBreakdown([
    ['description' => 'Tuition Fee', 'amount' => 12000.00],
    ['description' => 'Development Fee', 'amount' => 3000.00],
    ['description' => 'Transportation Fee', 'amount' => 5000.00],
    ['description' => 'Other Charges', 'amount' => 1000.00],
    'total' => ['description' => 'Total Fee', 'amount' => 21000.00]
]);

// Payment summary
$pdf->PaymentSummary([
    'total_fee' => 21000.00,
    'paid' => 7000.00,
    'balance' => 14000.00
]);

// Footer
$pdf->SchoolFooter('Admin User');

// Output PDF
$pdf->Output('I', 'Fee_Receipt.pdf');
?>