<?php
include '../includes/auth.php';
include '../config/db.php';
require '../classes/PDF.php';

// Get transaction ID
$transaction_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Fetch transaction details
$sql = "SELECT ft.*, s.first_name, s.last_name, s.admission_number, 
               c.class_name, sec.section_name, sec.section_id, fs.total_fee,
               mp.payment_month, ft.payment_mode, ft.payment_details
        FROM fee_transactions ft
        JOIN students s ON ft.student_id = s.student_id
        JOIN classes c ON s.class_id = c.class_id
        JOIN sections sec ON c.section_id = sec.section_id
        JOIN fee_structure fs ON s.class_id = fs.class_id
        LEFT JOIN monthly_payments mp ON ft.transaction_id = mp.transaction_id
        WHERE ft.transaction_id = $transaction_id";
$result = $conn->query($sql);

if ($result->num_rows == 0) {
    die("Transaction not found");
}

$transaction = $result->fetch_assoc();

// Get school settings
$settings_sql = "SELECT school_name_pre_primary, school_name_primary, school_name_secondary, 
                        address, phone, email 
                 FROM settings WHERE id = 1";
$settings_result = $conn->query($settings_sql);
$settings = $settings_result->fetch_assoc();

// Determine which school name to use based on section_id
$school_name = '';
if ($transaction['section_id'] == 1) { // Assuming 1 is Pre-primary section ID
    $school_name = $settings['school_name_pre_primary'];
} elseif ($transaction['section_id'] == 2) { // Assuming 2 is Primary section ID
    $school_name = $settings['school_name_primary'];
} else { // Secondary section
    $school_name = $settings['school_name_secondary'];
}

// Get monthly payment details
$monthly_sql = "SELECT payment_month 
                FROM monthly_payments 
                WHERE transaction_id = $transaction_id 
                ORDER BY payment_month";
$monthly_result = $conn->query($monthly_sql);
$paid_months = [];
while ($row = $monthly_result->fetch_assoc()) {
    $paid_months[] = $row['payment_month'];
}

// Create PDF with half A4 size
$pdf = new PDF('P', 'mm', array(148.5, 210)); // Half A4 size (A4 is 210x297mm)
$pdf->AddPage();

// School Header
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 8, $school_name, 0, 1, 'C');
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(0, 6, $settings['address'], 0, 1, 'C');
$pdf->Cell(0, 6, 'Phone: ' . $settings['phone'] . ' | Email: ' . $settings['email'], 0, 1, 'C');
$pdf->Ln(2);

// Receipt Title
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 8, 'FEE RECEIPT', 0, 1, 'C');
$pdf->Ln(2);

// Receipt Details
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(35, 6, 'Receipt No:', 0, 0);
$pdf->Cell(35, 6, $transaction['receipt_number'], 0, 0);
// $pdf->Cell(35, 6, 'Date:', 0, 0);
$pdf->Cell(0, 6, 'Date: ' . date('d/m/Y', strtotime($transaction['transaction_date'])), 0, 1, 'R');
$pdf->Ln(2);

// Student Details
$pdf->Cell(35, 6, 'Student Name:', 0, 0);
$pdf->Cell(35, 6, $transaction['first_name'] . ' ' . $transaction['last_name'], 0, 0);
// $pdf->Cell(35, 6, 'Class:', 0, 0);
$pdf->Cell(0, 6, 'Class: ' . $transaction['class_name'] . ' - ' . $transaction['section_name'], 0, 1, 'R');
$pdf->Cell(35, 6, 'Admission No:', 0, 0);
$pdf->Cell(0, 6, $transaction['admission_number'], 0, 1);
$pdf->Ln(2);

// Payment Details
// $pdf->SetFont('Arial', 'B', 10);
// $pdf->Cell(0, 6, 'Payment Details', 0, 1);
// $pdf->SetFont('Arial', '', 10);

// Create table header
$pdf->SetFillColor(240, 240, 240);
$pdf->SetFont('Arial', 'B', 9);
$pdf->Cell(45, 6, 'Description', 1, 0, 'L', true);
$pdf->Cell(45, 6, 'Amount', 1, 0, 'R', true);
$pdf->Cell(45, 6, 'Payment Mode', 1, 1, 'L', true);

// Table content
$pdf->SetFont('Arial', '', 9);

// Total Fee Row
$pdf->Cell(45, 6, 'Total Fee', 1, 0);
$pdf->Cell(45, 6, number_format($transaction['total_fee'], 2), 1, 0, 'R');
$pdf->Cell(45, 6, '', 1, 1);

// Amount Paid Row
$pdf->Cell(45, 6, 'Amount Paid', 1, 0);
$pdf->Cell(45, 6, number_format($transaction['amount_paid'], 2), 1, 0, 'R');
$pdf->Cell(45, 6, $transaction['payment_mode'], 1, 1);

// Payment Details Row (if not cash)
if ($transaction['payment_mode'] !== 'Cash' && !empty($transaction['payment_details'])) {
    $pdf->Cell(45, 6, 'Payment Details', 1, 0);
    $pdf->Cell(45, 6, $transaction['payment_details'], 1, 0, 'R');
    $pdf->Cell(45, 6, '', 1, 1);
}

// Balance Row
$pdf->Cell(45, 6, 'Balance', 1, 0);
$pdf->Cell(45, 6, number_format($transaction['balance_amount'], 2), 1, 0, 'R');
$pdf->Cell(45, 6, '', 1, 1);

// Monthly Payment Details
if (!empty($paid_months)) {
    $pdf->Ln(2);
    $pdf->SetFont('Arial', 'B', 10);
    
    // Format months list
    $month_names = array_map(function($month) {
        if ($month == 13) return 'Term-1';
        if ($month == 14) return 'Term-2';
        return date('F', mktime(0, 0, 0, $month, 1));
    }, $paid_months);
    
    $months_text = implode(', ', $month_names);
    $pdf->Cell(0, 6, 'Months: ' . $months_text . ' ' . 'of' . ' ' . date('Y', strtotime($transaction['transaction_date'])), 0, 1);
    
}

// Footer
$pdf->Ln(4);
$pdf->Cell(0, 6, 'Received by: ' . $_SESSION['full_name'], 0, 1);
$pdf->Cell(0, 6, '_________________________', 0, 1, 'R');
$pdf->Cell(0, 6, 'Authorized Signature', 0, 1, 'R');

// Output PDF
$pdf->Output('I', 'Fee_Receipt_' . $transaction['receipt_number'] . '.pdf');
?>