<?php
include '../includes/auth.php';
include '../config/db.php';

// Process form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $student_id = $conn->real_escape_string($_POST['student_id']);
    $amount_paid = $conn->real_escape_string($_POST['amount_paid']);
    $payment_mode = $conn->real_escape_string($_POST['payment_mode']);
    $payment_details = $conn->real_escape_string($_POST['payment_details'] ?? '');
    $remarks = $conn->real_escape_string($_POST['remarks'] ?? '');
    $months = isset($_POST['months']) ? $_POST['months'] : [];
    
    // Get student details
    $sql = "SELECT s.*, c.class_name, fs.total_fee 
            FROM students s
            JOIN classes c ON s.class_id = c.class_id
            JOIN fee_structure fs ON s.class_id = fs.class_id
            WHERE s.student_id = $student_id";
    $result = $conn->query($sql);
    $student = $result->fetch_assoc();
    
    // Calculate total paid so far
    $sql = "SELECT SUM(amount_paid) as total_paid 
            FROM fee_transactions 
            WHERE student_id = $student_id";
    $result = $conn->query($sql);
    $total_paid = $result->fetch_assoc()['total_paid'] ?? 0;
    
    $new_total_paid = $total_paid + $amount_paid;
    $balance_amount = $student['total_fee'] - $new_total_paid;
    
    // Generate sequential receipt number
    $today = date('Ymd');
    $sql = "SELECT receipt_number FROM fee_transactions 
            WHERE receipt_number LIKE '$today-%' 
            ORDER BY receipt_number DESC LIMIT 1";
    $result = $conn->query($sql);
    
    if ($result->num_rows > 0) {
        $last_receipt = $result->fetch_assoc()['receipt_number'];
        $last_number = intval(substr($last_receipt, -4));
        $new_number = $last_number + 1;
    } else {
        $new_number = 1;
    }
    
    $receipt_number = $today . '-' . str_pad($new_number, 4, '0', STR_PAD_LEFT);
    
    // Start transaction
    $conn->begin_transaction();
    
    try {
        // Insert transaction
        $sql = "INSERT INTO fee_transactions (
                    student_id, receipt_number, amount_paid, 
                    payment_mode, payment_details, collected_by, 
                    academic_year, balance_amount, remarks, transaction_date
                ) VALUES (
                    $student_id, '$receipt_number', $amount_paid, 
                    '$payment_mode', '$payment_details', '{$_SESSION['full_name']}', 
                    '{$student['academic_year']}', $balance_amount, '$remarks', CURRENT_TIMESTAMP
                )";
        
        if ($conn->query($sql) === TRUE) {
            $transaction_id = $conn->insert_id;
            
            // Insert monthly payments
            if (!empty($months)) {
                foreach ($months as $month) {
                    $month = $conn->real_escape_string($month);
                    $sql = "INSERT INTO monthly_payments (
                                transaction_id, student_id, payment_month, 
                                payment_year, amount
                            ) VALUES (
                                $transaction_id, $student_id, $month,
                                YEAR(CURRENT_DATE()), " . ($amount_paid / count($months)) . "
                            )";
                    $conn->query($sql);
                }
            }
            
            $conn->commit();
            header("Location: receipt.php?id=$transaction_id");
            exit();
        } else {
            throw new Exception("Error inserting transaction: " . $conn->error);
        }
    } catch (Exception $e) {
        $conn->rollback();
        $error = "Error: " . $e->getMessage();
    }
}

// Search functionality
$search_results = [];
if (isset($_GET['search'])) {
    $search_term = $conn->real_escape_string($_GET['search']);
    $sql = "SELECT s.*, c.class_name, fs.total_fee 
            FROM students s
            JOIN classes c ON s.class_id = c.class_id
            JOIN fee_structure fs ON s.class_id = fs.class_id
            WHERE s.admission_number LIKE '%$search_term%' 
               OR CONCAT(s.first_name, ' ', s.last_name) LIKE '%$search_term%'";
    $result = $conn->query($sql);
    $search_results = $result->fetch_all(MYSQLI_ASSOC);
}

// Function to get paid months for a student
function getPaidMonths($conn, $student_id) {
    $sql = "SELECT DISTINCT payment_month 
            FROM monthly_payments 
            WHERE student_id = $student_id 
            AND payment_year = YEAR(CURRENT_DATE())";
    $result = $conn->query($sql);
    $paid_months = [];
    while ($row = $result->fetch_assoc()) {
        $paid_months[] = $row['payment_month'];
    }
    return $paid_months;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Collect Fees</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link href="../assets/css/dashboard.css" rel="stylesheet">
</head>
<body>
    <?php include '../includes/header-internal.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Collect Fees</h1>
                </div>
                
                <?php if (isset($error)): ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <div class="card mb-4">
                    <div class="card-header">
                        Search Student
                    </div>
                    <div class="card-body">
                        <form method="GET" class="row g-3">
                            <div class="col-md-8">
                                <input type="text" name="search" class="form-control" placeholder="Search by admission number or name" required>
                            </div>
                            <div class="col-md-4">
                                <button type="submit" class="btn btn-primary">Search</button>
                            </div>
                        </form>
                        
                        <?php if (!empty($search_results)): ?>
                            <div class="mt-4">
                                <h5>Search Results</h5>
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>Admission No</th>
                                                <th>Student Name</th>
                                                <th>Class</th>
                                                <th>Total Fee</th>
                                                <th>Paid</th>
                                                <th>Balance</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($search_results as $student): 
                                                // Calculate paid amount
                                                $sql = "SELECT SUM(amount_paid) as total_paid 
                                                        FROM fee_transactions 
                                                        WHERE student_id = {$student['student_id']}";
                                                $result = $conn->query($sql);
                                                $paid = $result->fetch_assoc()['total_paid'] ?? 0;
                                                $balance = $student['total_fee'] - $paid;
                                            ?>
                                                <tr>
                                                    <td><?php echo $student['admission_number']; ?></td>
                                                    <td><?php echo $student['first_name'] . ' ' . $student['last_name']; ?></td>
                                                    <td><?php echo $student['class_name']; ?></td>
                                                    <td>₹<?php echo number_format($student['total_fee'], 2); ?></td>
                                                    <td>₹<?php echo number_format($paid, 2); ?></td>
                                                    <td class="<?php echo $balance > 0 ? 'text-danger' : 'text-success'; ?>">
                                                        ₹<?php echo number_format($balance, 2); ?>
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-sm btn-primary" 
                                                                data-bs-toggle="modal" 
                                                                data-bs-target="#paymentModal"
                                                                data-student-id="<?php echo $student['student_id']; ?>"
                                                                data-student-name="<?php echo $student['first_name'] . ' ' . $student['last_name']; ?>"
                                                                data-class-name="<?php echo $student['class_name']; ?>"
                                                                data-total-fee="<?php echo $student['total_fee']; ?>"
                                                                data-paid="<?php echo $paid; ?>"
                                                                data-balance="<?php echo $balance; ?>">
                                                            Collect Fee
                                                        </button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </main>
        </div>
    </div>
    
    <!-- Payment Modal -->
    <div class="modal fade" id="paymentModal" tabindex="-1" aria-labelledby="paymentModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST" action="collect.php">
                    <div class="modal-header">
                        <h5 class="modal-title" id="paymentModalLabel">Collect Fee</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="student_id" id="modalStudentId">
                        
                        <div class="mb-3">
                            <label class="form-label">Student Name</label>
                            <input type="text" class="form-control" id="modalStudentName" readonly>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Class</label>
                            <input type="text" class="form-control" id="modalClassName" readonly>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label class="form-label">Total Fee</label>
                                <input type="text" class="form-control" id="modalTotalFee" readonly>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Monthly Fee</label>
                                <input type="text" class="form-control" id="modalMonthlyFee" readonly>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Balance</label>
                                <input type="text" class="form-control" id="modalBalance" readonly>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Select Months *</label>
                            <div class="row" id="monthSelection">
                                <?php
                                $months = [
                                    13=> "Term-1" , 6 => 'June',
                                    7 => 'July', 8 => 'August', 9 => 'September',
                                    10 => 'October', 11 => 'November',14 => 'Term-2', 12 => 'December',1 => 'January', 2 => 'February', 3 => 'March',
                                    4 => 'April', 5 => 'May'
                                ];
                                foreach ($months as $num => $name) {
                                    echo "<div class='col-md-3 mb-2'>
                                            <div class='form-check'>
                                                <input class='form-check-input month-checkbox' type='checkbox' 
                                                       name='months[]' value='$num' id='month$num'>
                                                <label class='form-check-label' for='month$num'>$name</label>
                                            </div>
                                        </div>";
                                }
                                ?>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="amount_paid" class="form-label">Amount to Pay *</label>
                            <input type="number" class="form-control" id="amount_paid" name="amount_paid" required step="0.01" readonly>
                        </div>
                        
                        <div class="mb-3">
                            <label for="payment_mode" class="form-label">Payment Mode *</label>
                            <select class="form-select" id="payment_mode" name="payment_mode" required>
                                <option value="">Select Mode</option>
                                <option value="Cash">Cash</option>
                                <option value="Gpay">Gpay</option>
                                <option value="Cheque">Cheque</option>
                                <option value="Online Transfer">Online Transfer</option>
                                <option value="DD">DD</option>
                            </select>
                        </div>
                        
                        <div class="mb-3" id="paymentDetailsContainer" style="display: none;">
                            <label for="payment_details" class="form-label">Payment Details</label>
                            <input type="text" class="form-control" id="payment_details" name="payment_details" placeholder="Cheque no/Transaction reference">
                        </div>
                        
                        <div class="mb-3">
                            <label for="remarks" class="form-label">Remarks</label>
                            <textarea class="form-control" id="remarks" name="remarks" rows="2"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Submit Payment</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Handle modal show event
            const paymentModal = document.getElementById('paymentModal');
            if (paymentModal) {
                paymentModal.addEventListener('show.bs.modal', function (event) {
                    const button = event.relatedTarget;
                    const studentId = button.getAttribute('data-student-id');
                    
                    // Set student details
                    document.getElementById('modalStudentId').value = studentId;
                    document.getElementById('modalStudentName').value = button.getAttribute('data-student-name');
                    document.getElementById('modalClassName').value = button.getAttribute('data-class-name');
                    
                    // Format and set fee amounts
                    const totalFee = parseFloat(button.getAttribute('data-total-fee'));
                    const monthlyFee = totalFee / 14;
                    const balance = parseFloat(button.getAttribute('data-balance'));
                    
                    document.getElementById('modalTotalFee').value = '₹' + totalFee.toFixed(2);
                    document.getElementById('modalMonthlyFee').value = '₹' + monthlyFee.toFixed(2);
                    document.getElementById('modalBalance').value = '₹' + balance.toFixed(2);
                    
                    // Reset month selection and amount
                    document.querySelectorAll('.month-checkbox').forEach(checkbox => {
                        checkbox.checked = false;
                        checkbox.disabled = false;
                        checkbox.parentElement.classList.remove('text-muted');
                    });
                    document.getElementById('amount_paid').value = '';

                    // Fetch and disable paid months
                    fetch(`get_paid_months.php?student_id=${studentId}`)
                        .then(response => response.json())
                        .then(paidMonths => {
                            paidMonths.forEach(month => {
                                const checkbox = document.getElementById(`month${month}`);
                                if (checkbox) {
                                    checkbox.disabled = true;
                                    checkbox.parentElement.classList.add('text-muted');
                                }
                            });
                        })
                        .catch(error => console.error('Error fetching paid months:', error));
                });
            }

            // Show payment details field when not Cash
            const paymentMode = document.getElementById('payment_mode');
            if (paymentMode) {
                paymentMode.addEventListener('change', function() {
                    const detailsContainer = document.getElementById('paymentDetailsContainer');
                    const paymentDetails = document.getElementById('payment_details');
                    if (detailsContainer) {
                        detailsContainer.style.display = this.value === 'Cash' ? 'none' : 'block';
                        paymentDetails.required = this.value !== 'Cash';
                    }
                });
            }

            // Update amount when months are selected
            document.querySelectorAll('.month-checkbox').forEach(checkbox => {
                checkbox.addEventListener('change', function() {
                    const totalFee = parseFloat(document.getElementById('modalTotalFee').value.replace('₹', ''));
                    const selectedMonths = document.querySelectorAll('.month-checkbox:checked');
                    const totalMonths = 14; // Total number of months including terms
                    const monthlyAmount = totalFee / totalMonths;
                    
                    // Calculate amount based on selected months
                    let totalAmount = 0;
                    selectedMonths.forEach(month => {
                        const monthValue = parseInt(month.value);
                        totalAmount += monthlyAmount;
                        
                    });
                    
                    document.getElementById('amount_paid').value = totalAmount.toFixed(2);
                });
            });
        });
    </script>
</body>
</html>