<?php
include 'includes/auth.php'; // This will check for authentication
include 'config/db.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>School Fee System - Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link href="./assets/css/dashboard.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Dashboard</h1>
                </div>
                
                <!-- Today's Collection Summary -->
                <div class="row mb-4">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                Today's Collection
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <?php
                                    // Get today's date
                                    $today = date('Y-m-d');
                                    
                                    // Total collection today
                                    $sql = "SELECT SUM(amount_paid) as total FROM fee_transactions 
                                            WHERE DATE(transaction_date) = '$today'";
                                    $result = $conn->query($sql);
                                    $today_total = $result->fetch_assoc()['total'] ?? 0;
                                    
                                    // Number of transactions today
                                    $sql = "SELECT COUNT(*) as count FROM fee_transactions 
                                            WHERE DATE(transaction_date) = '$today'";
                                    $result = $conn->query($sql);
                                    $today_count = $result->fetch_assoc()['count'] ?? 0;
                                    
                                    // Payment mode breakdown
                                    $sql = "SELECT payment_mode, SUM(amount_paid) as total 
                                            FROM fee_transactions 
                                            WHERE DATE(transaction_date) = '$today'
                                            GROUP BY payment_mode";
                                    $result = $conn->query($sql);
                                    $payment_modes = [];
                                    while ($row = $result->fetch_assoc()) {
                                        $payment_modes[$row['payment_mode']] = $row['total'];
                                    }
                                    ?>
                                    
                                    <div class="col-md-3">
                                        <div class="card text-white bg-primary mb-3">
                                            <div class="card-body">
                                                <h5 class="card-title">Total Collection</h5>
                                                <p class="card-text fs-4">₹<?php echo number_format($today_total, 2); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-3">
                                        <div class="card text-white bg-success mb-3">
                                            <div class="card-body">
                                                <h5 class="card-title">Transactions</h5>
                                                <p class="card-text fs-4"><?php echo $today_count; ?></p>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <canvas id="paymentModeChart" height="100"></canvas>
                                        <script>
                                            document.addEventListener('DOMContentLoaded', function() {
                                                const ctx = document.getElementById('paymentModeChart').getContext('2d');
                                                const chart = new Chart(ctx, {
                                                    type: 'doughnut',
                                                    data: {
                                                        labels: <?php echo json_encode(array_keys($payment_modes)); ?>,
                                                        datasets: [{
                                                            data: <?php echo json_encode(array_values($payment_modes)); ?>,
                                                            backgroundColor: [
                                                                '#FF6384',
                                                                '#36A2EB',
                                                                '#FFCE56',
                                                                '#4BC0C0'
                                                            ]
                                                        }]
                                                    },
                                                    options: {
                                                        responsive: true,
                                                        plugins: {
                                                            legend: {
                                                                position: 'bottom',
                                                            },
                                                            title: {
                                                                display: true,
                                                                text: 'Payment Mode Distribution'
                                                            }
                                                        }
                                                    }
                                                });
                                            });
                                        </script>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Recent Transactions -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                Recent Transactions
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover">
                                        <thead>
                                            <tr>
                                                <th>Receipt No</th>
                                                <th>Date</th>
                                                <th>Student</th>
                                                <th>Class</th>
                                                <th>Amount</th>
                                                <th>Mode</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $sql = "SELECT ft.*, s.first_name, s.last_name, c.class_name 
                                                    FROM fee_transactions ft
                                                    JOIN students s ON ft.student_id = s.student_id
                                                    JOIN classes c ON s.class_id = c.class_id
                                                    ORDER BY ft.transaction_date DESC LIMIT 10";
                                            $result = $conn->query($sql);
                                            
                                            if ($result->num_rows > 0) {
                                                while ($row = $result->fetch_assoc()) {
                                                    echo "<tr>
                                                        <td>{$row['receipt_number']}</td>
                                                        <td>" . date('d/m/Y', strtotime($row['transaction_date'])) . "</td>
                                                        <td>{$row['first_name']} {$row['last_name']}</td>
                                                        <td>{$row['class_name']}</td>
                                                        <td>₹" . number_format($row['amount_paid'], 2) . "</td>
                                                        <td>{$row['payment_mode']}</td>
                                                        <td><a href='fees/receipt.php?id={$row['transaction_id']}' class='btn btn-sm btn-primary' target='_blank'>Print</a></td>
                                                    </tr>";
                                                }
                                            } else {
                                                echo "<tr><td colspan='7' class='text-center'>No transactions found</td></tr>";
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>