users.php<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../config/db.php';

// Only admin can access this page
requireRole('admin');

// Set page title
$pageTitle = "User Management";

// Handle user actions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add_user'])) {
        // Add new user
        $username = $conn->real_escape_string($_POST['username']);
        $password = password_hash($conn->real_escape_string($_POST['password']), PASSWORD_DEFAULT);
        $role = $conn->real_escape_string($_POST['role']);
        $full_name = $conn->real_escape_string($_POST['full_name']);
        
        $sql = "INSERT INTO users (username, password, role, full_name, status) 
                VALUES ('$username', '$password', '$role', '$full_name', 'active')";
        $conn->query($sql);
        setFlashMessage('success', 'User added successfully');
    } elseif (isset($_POST['update_user'])) {
        // Update existing user
        $user_id = intval($_POST['user_id']);
        $role = $conn->real_escape_string($_POST['role']);
        $full_name = $conn->real_escape_string($_POST['full_name']);
        $status = $conn->real_escape_string($_POST['status']);
        
        $sql = "UPDATE users SET 
                role = '$role', 
                full_name = '$full_name',
                status = '$status'
                WHERE user_id = $user_id";
        $conn->query($sql);
        setFlashMessage('success', 'User updated successfully');
    } elseif (isset($_POST['reset_password'])) {
        // Reset password
        $user_id = intval($_POST['user_id']);
        $password = password_hash('password123', PASSWORD_DEFAULT); // Default password
        
        $sql = "UPDATE users SET password = '$password' WHERE user_id = $user_id";
        $conn->query($sql);
        setFlashMessage('success', 'Password reset to default');
    }
    
    header("Location: users.php");
    exit();
}

// Get all users
$sql = "SELECT * FROM users ORDER BY role, username";
$result = $conn->query($sql);
$users = $result->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <?php include '../includes/header-internal.php'; ?>
    <style>
        .role-admin { background-color: #ffe8e8; }
        .role-accountant { background-color: #e8f4ff; }
        .role-teacher { background-color: #f0ffe8; }
    </style>
</head>
<body>
   
    <div class="container-fluid">
        <div class="row">
         
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">User Management</h1>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addUserModal">
                        <i class="fas fa-plus"></i> Add User
                    </button>
                </div>
                
                <?php $successMessage = getFlashMessage('success'); ?>
                <?php if ($successMessage): ?>
                    <div class="alert alert-success"><?= $successMessage ?></div>
                <?php endif; ?>
                
                <div class="table-responsive">
                    <table class="table table-striped table-hover data-table">
                        <thead>
                            <tr>
                                <th>Username</th>
                                <th>Full Name</th>
                                <th>Role</th>
                                <th>Status</th>
                                <th>Last Login</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($users as $user): ?>
                            <tr class="role-<?= $user['role'] ?>">
                                <td><?= htmlspecialchars($user['username']) ?></td>
                                <td><?= htmlspecialchars($user['full_name']) ?></td>
                                <td><?= ucfirst($user['role']) ?></td>
                                <td>
                                    <span class="badge bg-<?= $user['status'] == 'active' ? 'success' : 'secondary' ?>">
                                        <?= ucfirst($user['status']) ?>
                                    </span>
                                </td>
                                <td><?= $user['last_login'] ? date('d/m/Y H:i', strtotime($user['last_login'])) : 'Never' ?></td>
                                <td>
                                    <button class="btn btn-sm btn-warning edit-user" 
                                            data-userid="<?= $user['user_id'] ?>"
                                            data-username="<?= htmlspecialchars($user['username']) ?>"
                                            data-fullname="<?= htmlspecialchars($user['full_name']) ?>"
                                            data-role="<?= $user['role'] ?>"
                                            data-status="<?= $user['status'] ?>">
                                        <i class="fas fa-edit"></i> Edit
                                    </button>
                                    <form method="POST" style="display:inline;">
                                        <input type="hidden" name="user_id" value="<?= $user['user_id'] ?>">
                                        <button type="submit" name="reset_password" class="btn btn-sm btn-info">
                                            <i class="fas fa-key"></i> Reset Password
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </main>
        </div>
    </div>

    <!-- Add User Modal -->
    <div class="modal fade" id="addUserModal" tabindex="-1" aria-labelledby="addUserModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addUserModalLabel">Add New User</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="username" class="form-label">Username *</label>
                            <input type="text" class="form-control" id="username" name="username" required>
                        </div>
                        <div class="mb-3">
                            <label for="password" class="form-label">Password *</label>
                            <input type="password" class="form-control" id="password" name="password" required>
                        </div>
                        <div class="mb-3">
                            <label for="full_name" class="form-label">Full Name *</label>
                            <input type="text" class="form-control" id="full_name" name="full_name" required>
                        </div>
                        <div class="mb-3">
                            <label for="role" class="form-label">Role *</label>
                            <select class="form-select" id="role" name="role" required>
                                <option value="admin">Admin</option>
                                <option value="accountant">Accountant</option>
                                <option value="teacher">Teacher</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" name="add_user" class="btn btn-primary">Add User</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit User Modal -->
    <div class="modal fade" id="editUserModal" tabindex="-1" aria-labelledby="editUserModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <input type="hidden" id="edit_user_id" name="user_id">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editUserModalLabel">Edit User</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Username</label>
                            <input type="text" class="form-control" id="edit_username" readonly>
                        </div>
                        <div class="mb-3">
                            <label for="edit_full_name" class="form-label">Full Name *</label>
                            <input type="text" class="form-control" id="edit_full_name" name="full_name" required>
                        </div>
                        <div class="mb-3">
                            <label for="edit_role" class="form-label">Role *</label>
                            <select class="form-select" id="edit_role" name="role" required>
                                <option value="admin">Admin</option>
                                <option value="accountant">Accountant</option>
                                <option value="teacher">Teacher</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="edit_status" class="form-label">Status *</label>
                            <select class="form-select" id="edit_status" name="status" required>
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" name="update_user" class="btn btn-primary">Save Changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php include '../includes/footer.php'; ?>
    <script src="../assets/js/main.js"></script>
    <script>
        // Handle edit user button clicks
        document.querySelectorAll('.edit-user').forEach(button => {
            button.addEventListener('click', function() {
                const modal = new bootstrap.Modal(document.getElementById('editUserModal'));
                document.getElementById('edit_user_id').value = this.dataset.userid;
                document.getElementById('edit_username').value = this.dataset.username;
                document.getElementById('edit_full_name').value = this.dataset.fullname;
                document.getElementById('edit_role').value = this.dataset.role;
                document.getElementById('edit_status').value = this.dataset.status;
                modal.show();
            });
        });
    </script>
</body>
</html>