<?php
require_once '../includes/auth.php';
require_once '../config/db.php';

// Check if user is admin
if (!isset($_SESSION['is_admin']) || $_SESSION['is_admin'] != 1) {
    header('Location: ../index.php');
    exit();
}

$message = '';
$error = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $school_name_pre_primary = $_POST['school_name_pre_primary'];
    $school_name_primary = $_POST['school_name_primary'];
    $school_name_secondary = $_POST['school_name_secondary'];
    $address = $_POST['address'];
    $phone = $_POST['phone'];
    $email = $_POST['email'];
    $website = $_POST['website'];

    // Handle logo upload
    $logo_path = '';
    if (isset($_FILES['logo']) && $_FILES['logo']['error'] == 0) {
        $allowed = ['jpg', 'jpeg', 'png', 'gif'];
        $filename = $_FILES['logo']['name'];
        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        
        if (in_array($ext, $allowed)) {
            $new_filename = 'logo_' . time() . '.' . $ext;
            $upload_path = '../uploads/' . $new_filename;
            
            if (move_uploaded_file($_FILES['logo']['tmp_name'], $upload_path)) {
                $logo_path = 'uploads/' . $new_filename;
            }
        }
    }

    // Update settings
    $sql = "UPDATE settings SET 
            school_name_pre_primary = ?,
            school_name_primary = ?,
            school_name_secondary = ?,
            address = ?,
            phone = ?,
            email = ?,
            website = ?";
    
    $params = [$school_name_pre_primary, $school_name_primary, $school_name_secondary, 
               $address, $phone, $email, $website];
    $types = 'sssssss';

    if ($logo_path) {
        $sql .= ", logo_path = ?";
        $params[] = $logo_path;
        $types .= 's';
    }

    $sql .= " WHERE id = 1";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param($types, ...$params);

    if ($stmt->execute()) {
        $message = "Settings updated successfully!";
    } else {
        $error = "Error updating settings: " . $conn->error;
    }
}

// Get current settings
$sql = "SELECT * FROM settings WHERE id = 1";
$result = $conn->query($sql);
$settings = $result->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <?php include '../includes/header-internal.php'; ?>
    <title>School Settings</title>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include '../includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">School Settings</h1>
                </div>

                <?php if ($message): ?>
                    <div class="alert alert-success"><?php echo $message; ?></div>
                <?php endif; ?>

                <?php if ($error): ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-body">
                        <form method="POST" enctype="multipart/form-data">
                            <div class="row mb-3">
                                <div class="col-md-4">
                                    <label for="school_name_pre_primary" class="form-label">Pre-Primary School Name</label>
                                    <input type="text" class="form-control" id="school_name_pre_primary" 
                                           name="school_name_pre_primary" 
                                           value="<?php echo htmlspecialchars($settings['school_name_pre_primary']); ?>" required>
                                </div>
                                <div class="col-md-4">
                                    <label for="school_name_primary" class="form-label">Primary School Name</label>
                                    <input type="text" class="form-control" id="school_name_primary" 
                                           name="school_name_primary" 
                                           value="<?php echo htmlspecialchars($settings['school_name_primary']); ?>" required>
                                </div>
                                <div class="col-md-4">
                                    <label for="school_name_secondary" class="form-label">Secondary School Name</label>
                                    <input type="text" class="form-control" id="school_name_secondary" 
                                           name="school_name_secondary" 
                                           value="<?php echo htmlspecialchars($settings['school_name_secondary']); ?>" required>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label for="phone" class="form-label">Phone Number</label>
                                    <input type="text" class="form-control" id="phone" name="phone" 
                                           value="<?php echo htmlspecialchars($settings['phone']); ?>" required>
                                </div>
                                <div class="col-md-6">
                                    <label for="email" class="form-label">Email Address</label>
                                    <input type="email" class="form-control" id="email" name="email" 
                                           value="<?php echo htmlspecialchars($settings['email']); ?>" required>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label for="website" class="form-label">Website</label>
                                    <input type="url" class="form-control" id="website" name="website" 
                                           value="<?php echo htmlspecialchars($settings['website']); ?>">
                                </div>
                                <div class="col-md-6">
                                    <label for="logo" class="form-label">School Logo</label>
                                    <?php if ($settings['logo_path']): ?>
                                        <div class="mb-2">
                                            <img src="../<?php echo htmlspecialchars($settings['logo_path']); ?>" 
                                                 alt="Current Logo" style="max-height: 100px;">
                                        </div>
                                    <?php endif; ?>
                                    <input type="file" class="form-control" id="logo" name="logo" accept="image/*">
                                    <small class="text-muted">Leave empty to keep current logo</small>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="address" class="form-label">Address</label>
                                <textarea class="form-control" id="address" name="address" rows="3" required><?php echo htmlspecialchars($settings['address']); ?></textarea>
                            </div>

                            <button type="submit" class="btn btn-primary">Save Settings</button>
                        </form>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <?php include '../includes/footer.php'; ?>
</body>
</html> 