<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../config/db.php';

// Only admin can access this page
requireRole('admin');

// Set page title
$pageTitle = "Fee Structure Management";

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add_fee_structure'])) {
        // Add new fee structure
        $class_id = intval($_POST['class_id']);
        $academic_year = $conn->real_escape_string($_POST['academic_year']);
        $tuition_fee = floatval($_POST['tuition_fee']);
        $development_fee = floatval($_POST['development_fee']);
        $transportation_fee = floatval($_POST['transportation_fee']);
        $other_charges = floatval($_POST['other_charges']);
        $due_date = $conn->real_escape_string($_POST['due_date']);
        $installment_allowed = isset($_POST['installment_allowed']) ? 1 : 0;
        $no_of_installments = $installment_allowed ? intval($_POST['no_of_installments']) : 1;
        
        $total_fee = $tuition_fee + $development_fee + $transportation_fee + $other_charges;
        
        $sql = "INSERT INTO fee_structure (class_id, academic_year, tuition_fee, development_fee, 
                transportation_fee, other_charges, total_fee, due_date, installment_allowed, no_of_installments)
                VALUES ($class_id, '$academic_year', $tuition_fee, $development_fee, $transportation_fee,
                $other_charges, $total_fee, '$due_date', $installment_allowed, $no_of_installments)";
        $conn->query($sql);
        setFlashMessage('success', 'Fee structure added successfully');
    } elseif (isset($_POST['update_fee_structure'])) {
        // Update fee structure
        $fee_structure_id = intval($_POST['fee_structure_id']);
        $tuition_fee = floatval($_POST['tuition_fee']);
        $development_fee = floatval($_POST['development_fee']);
        $transportation_fee = floatval($_POST['transportation_fee']);
        $other_charges = floatval($_POST['other_charges']);
        $due_date = $conn->real_escape_string($_POST['due_date']);
        $installment_allowed = isset($_POST['installment_allowed']) ? 1 : 0;
        $no_of_installments = $installment_allowed ? intval($_POST['no_of_installments']) : 1;
        
        $total_fee = $tuition_fee + $development_fee + $transportation_fee + $other_charges;
        
        $sql = "UPDATE fee_structure SET 
                tuition_fee = $tuition_fee,
                development_fee = $development_fee,
                transportation_fee = $transportation_fee,
                other_charges = $other_charges,
                total_fee = $total_fee,
                due_date = '$due_date',
                installment_allowed = $installment_allowed,
                no_of_installments = $no_of_installments
                WHERE fee_structure_id = $fee_structure_id";
        $conn->query($sql);
        setFlashMessage('success', 'Fee structure updated successfully');
    }
    
    header("Location: fee-structure.php");
    exit();
}

// Get all fee structures with class information
$sql = "SELECT fs.*, c.class_name, sec.section_name 
        FROM fee_structure fs
        JOIN classes c ON fs.class_id = c.class_id
        JOIN sections sec ON c.section_id = sec.section_id
        ORDER BY sec.section_id, c.class_id";
$result = $conn->query($sql);
$fee_structures = $result->fetch_all(MYSQLI_ASSOC);

// Get all classes for dropdown
$sql = "SELECT c.class_id, c.class_name, sec.section_name 
        FROM classes c
        JOIN sections sec ON c.section_id = sec.section_id
        ORDER BY sec.section_id, c.class_id";
$classes_result = $conn->query($sql);
$classes = $classes_result->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <?php include '../includes/header-internal.php'; ?>
</head>
<body>
   
    <div class="container-fluid">
        <div class="row">
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Fee Structure Management</h1>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addFeeStructureModal">
                        <i class="fas fa-plus"></i> Add Fee Structure
                    </button>
                </div>
                
                <?php $successMessage = getFlashMessage('success'); ?>
                <?php if ($successMessage): ?>
                    <div class="alert alert-success"><?= $successMessage ?></div>
                <?php endif; ?>
                
                <div class="table-responsive">
                    <table class="table table-striped table-hover data-table">
                        <thead>
                            <tr>
                                <th>Class</th>
                                <th>Section</th>
                                <th>Academic Year</th>
                                <th>Total Fee</th>
                                <th>Due Date</th>
                                <th>Installments</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($fee_structures as $fs): ?>
                            <tr>
                                <td><?= htmlspecialchars($fs['class_name']) ?></td>
                                <td><?= htmlspecialchars($fs['section_name']) ?></td>
                                <td><?= htmlspecialchars($fs['academic_year']) ?></td>
                                <td>₹<?= number_format($fs['total_fee'], 2) ?></td>
                                <td><?= date('d/m/Y', strtotime($fs['due_date'])) ?></td>
                                <td>
                                    <?= $fs['installment_allowed'] ? 
                                        'Yes ('.$fs['no_of_installments'].')' : 'No' ?>
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-warning edit-fee-structure" 
                                            data-fsid="<?= $fs['fee_structure_id'] ?>"
                                            data-classid="<?= $fs['class_id'] ?>"
                                            data-academicyear="<?= htmlspecialchars($fs['academic_year']) ?>"
                                            data-tuition="<?= $fs['tuition_fee'] ?>"
                                            data-development="<?= $fs['development_fee'] ?>"
                                            data-transportation="<?= $fs['transportation_fee'] ?>"
                                            data-other="<?= $fs['other_charges'] ?>"
                                            data-duedate="<?= $fs['due_date'] ?>"
                                            data-installment="<?= $fs['installment_allowed'] ?>"
                                            data-noinstallments="<?= $fs['no_of_installments'] ?>">
                                        <i class="fas fa-edit"></i> Edit
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </main>
        </div>
    </div>

    <!-- Add Fee Structure Modal -->
    <div class="modal fade" id="addFeeStructureModal" tabindex="-1" aria-labelledby="addFeeStructureModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form method="POST">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addFeeStructureModalLabel">Add Fee Structure</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="class_id" class="form-label">Class *</label>
                                <select class="form-select" id="class_id" name="class_id" required>
                                    <option value="">Select Class</option>
                                    <?php foreach ($classes as $class): ?>
                                    <option value="<?= $class['class_id'] ?>">
                                        <?= $class['section_name'] ?> - <?= $class['class_name'] ?>
                                    </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="academic_year" class="form-label">Academic Year *</label>
                                <input type="text" class="form-control" id="academic_year" name="academic_year" 
                                       value="<?= date('Y') ?>-<?= date('Y')+1 ?>" required>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="tuition_fee" class="form-label">Tuition Fee *</label>
                                <input type="number" step="0.01" class="form-control" id="tuition_fee" name="tuition_fee" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="development_fee" class="form-label">Development Fee *</label>
                                <input type="number" step="0.01" class="form-control" id="development_fee" name="development_fee" required>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="transportation_fee" class="form-label">Transportation Fee</label>
                                <input type="number" step="0.01" class="form-control" id="transportation_fee" name="transportation_fee" value="0">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="other_charges" class="form-label">Other Charges</label>
                                <input type="number" step="0.01" class="form-control" id="other_charges" name="other_charges" value="0">
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="due_date" class="form-label">Due Date *</label>
                                <input type="date" class="form-control" id="due_date" name="due_date" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="installment_allowed" name="installment_allowed">
                                    <label class="form-check-label" for="installment_allowed">
                                        Allow Installments
                                    </label>
                                </div>
                                <div id="installmentDetails" style="display:none;">
                                    <label for="no_of_installments" class="form-label">Number of Installments</label>
                                    <select class="form-select" id="no_of_installments" name="no_of_installments">
                                        <option value="2">2</option>
                                        <option value="3" selected>3</option>
                                        <option value="4">4</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" name="add_fee_structure" class="btn btn-primary">Save Fee Structure</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Fee Structure Modal -->
    <div class="modal fade" id="editFeeStructureModal" tabindex="-1" aria-labelledby="editFeeStructureModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form method="POST">
                    <input type="hidden" id="edit_fee_structure_id" name="fee_structure_id">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editFeeStructureModalLabel">Edit Fee Structure</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Class</label>
                                <input type="text" class="form-control" id="edit_class_name" readonly>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Academic Year</label>
                                <input type="text" class="form-control" id="edit_academic_year" readonly>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="edit_tuition_fee" class="form-label">Tuition Fee *</label>
                                <input type="number" step="0.01" class="form-control" id="edit_tuition_fee" name="tuition_fee" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="edit_development_fee" class="form-label">Development Fee *</label>
                                <input type="number" step="0.01" class="form-control" id="edit_development_fee" name="development_fee" required>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="edit_transportation_fee" class="form-label">Transportation Fee</label>
                                <input type="number" step="0.01" class="form-control" id="edit_transportation_fee" name="transportation_fee">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="edit_other_charges" class="form-label">Other Charges</label>
                                <input type="number" step="0.01" class="form-control" id="edit_other_charges" name="other_charges">
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="edit_due_date" class="form-label">Due Date *</label>
                                <input type="date" class="form-control" id="edit_due_date" name="due_date" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="edit_installment_allowed" name="installment_allowed">
                                    <label class="form-check-label" for="edit_installment_allowed">
                                        Allow Installments
                                    </label>
                                </div>
                                <div id="edit_installmentDetails">
                                    <label for="edit_no_of_installments" class="form-label">Number of Installments</label>
                                    <select class="form-select" id="edit_no_of_installments" name="no_of_installments">
                                        <option value="2">2</option>
                                        <option value="3">3</option>
                                        <option value="4">4</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" name="update_fee_structure" class="btn btn-primary">Update Fee Structure</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php include '../includes/footer.php'; ?>
     <script src="../assets/js/main.js"></script>
    <script>
        // Show/hide installment details based on checkbox
        document.getElementById('installment_allowed').addEventListener('change', function() {
            document.getElementById('installmentDetails').style.display = this.checked ? 'block' : 'none';
        });
        
        // Handle edit fee structure button clicks
        document.querySelectorAll('.edit-fee-structure').forEach(button => {
            button.addEventListener('click', function() {
                const modal = new bootstrap.Modal(document.getElementById('editFeeStructureModal'));
                
                // Get class name
                const classId = this.dataset.classid;
                const className = document.querySelector(`#class_id option[value="${classId}"]`).textContent;
                
                // Set form values
                document.getElementById('edit_fee_structure_id').value = this.dataset.fsid;
                document.getElementById('edit_class_name').value = className;
                document.getElementById('edit_academic_year').value = this.dataset.academicyear;
                document.getElementById('edit_tuition_fee').value = this.dataset.tuition;
                document.getElementById('edit_development_fee').value = this.dataset.development;
                document.getElementById('edit_transportation_fee').value = this.dataset.transportation;
                document.getElementById('edit_other_charges').value = this.dataset.other;
                document.getElementById('edit_due_date').value = this.dataset.duedate;
                
                // Handle installments
                const installmentAllowed = this.dataset.installment === '1';
                document.getElementById('edit_installment_allowed').checked = installmentAllowed;
                document.getElementById('edit_installmentDetails').style.display = installmentAllowed ? 'block' : 'none';
                document.getElementById('edit_no_of_installments').value = this.dataset.noinstallments;
                
                modal.show();
            });
        });
        
        // Set due date default to today + 30 days
        const today = new Date();
        today.setDate(today.getDate() + 30);
        const dueDate = today.toISOString().split('T')[0];
        document.getElementById('due_date').value = dueDate;
    </script>
</body>
</html>