<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../config/db.php';

// Only admin can access this page
requireRole('admin');

// Set page title
$pageTitle = "Class Management";

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add_class'])) {
        // Add new class
        $class_name = $conn->real_escape_string($_POST['class_name']);
        $section_id = intval($_POST['section_id']);
        $max_strength = intval($_POST['max_strength']);
        
        $sql = "INSERT INTO classes (class_name, section_id, max_strength)
                VALUES ('$class_name', $section_id, $max_strength)";
        $conn->query($sql);
        setFlashMessage('success', 'Class added successfully');
    } elseif (isset($_POST['update_class'])) {
        // Update class
        $class_id = intval($_POST['class_id']);
        $class_name = $conn->real_escape_string($_POST['class_name']);
        $section_id = intval($_POST['section_id']);
        $max_strength = intval($_POST['max_strength']);
        
        $sql = "UPDATE classes SET 
                class_name = '$class_name',
                section_id = $section_id,
                max_strength = $max_strength
                WHERE class_id = $class_id";
        $conn->query($sql);
        setFlashMessage('success', 'Class updated successfully');
    }
    
    header("Location: classes.php");
    exit();
}

// Get all classes with section information
$sql = "SELECT c.*, sec.section_name 
        FROM classes c
        JOIN sections sec ON c.section_id = sec.section_id
        ORDER BY sec.section_id, c.class_name";
$result = $conn->query($sql);
$classes = $result->fetch_all(MYSQLI_ASSOC);

// Get all sections for dropdown
$sql = "SELECT * FROM sections ORDER BY section_id";
$sections_result = $conn->query($sql);
$sections = $sections_result->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
     <?php include '../includes/header-internal.php'; ?>
</head>
<body>
  
    
    <div class="container-fluid">
        <div class="row">
           
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Class Management</h1>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addClassModal">
                        <i class="fas fa-plus"></i> Add Class
                    </button>
                </div>
                
                <?php $successMessage = getFlashMessage('success'); ?>
                <?php if ($successMessage): ?>
                    <div class="alert alert-success"><?= $successMessage ?></div>
                <?php endif; ?>
                
                <div class="table-responsive">
                    <table class="table table-striped table-hover data-table">
                        <thead>
                            <tr>
                                <th>Class Name</th>
                                <th>Section</th>
                                <th>Max Strength</th>
                                <th>Current Strength</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($classes as $class): ?>
                            <tr>
                                <td><?= htmlspecialchars($class['class_name']) ?></td>
                                <td><?= htmlspecialchars($class['section_name']) ?></td>
                                <td><?= $class['max_strength'] ?></td>
                                <td><?= $class['current_strength'] ?></td>
                                <td>
                                    <button class="btn btn-sm btn-warning edit-class" 
                                            data-classid="<?= $class['class_id'] ?>"
                                            data-classname="<?= htmlspecialchars($class['class_name']) ?>"
                                            data-sectionid="<?= $class['section_id'] ?>"
                                            data-maxstrength="<?= $class['max_strength'] ?>">
                                        <i class="fas fa-edit"></i> Edit
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </main>
        </div>
    </div>

    <!-- Add Class Modal -->
    <div class="modal fade" id="addClassModal" tabindex="-1" aria-labelledby="addClassModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addClassModalLabel">Add New Class</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="class_name" class="form-label">Class Name *</label>
                            <input type="text" class="form-control" id="class_name" name="class_name" required>
                        </div>
                        <div class="mb-3">
                            <label for="section_id" class="form-label">Section *</label>
                            <select class="form-select" id="section_id" name="section_id" required>
                                <option value="">Select Section</option>
                                <?php foreach ($sections as $section): ?>
                                <option value="<?= $section['section_id'] ?>"><?= $section['section_name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="max_strength" class="form-label">Maximum Strength *</label>
                            <input type="number" class="form-control" id="max_strength" name="max_strength" value="40" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" name="add_class" class="btn btn-primary">Add Class</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Class Modal -->
    <div class="modal fade" id="editClassModal" tabindex="-1" aria-labelledby="editClassModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form method="POST">
                    <input type="hidden" id="edit_class_id" name="class_id">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editClassModalLabel">Edit Class</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="edit_class_name" class="form-label">Class Name *</label>
                            <input type="text" class="form-control" id="edit_class_name" name="class_name" required>
                        </div>
                        <div class="mb-3">
                            <label for="edit_section_id" class="form-label">Section *</label>
                            <select class="form-select" id="edit_section_id" name="section_id" required>
                                <?php foreach ($sections as $section): ?>
                                <option value="<?= $section['section_id'] ?>"><?= $section['section_name'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="edit_max_strength" class="form-label">Maximum Strength *</label>
                            <input type="number" class="form-control" id="edit_max_strength" name="max_strength" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" name="update_class" class="btn btn-primary">Update Class</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php include '../includes/footer.php'; ?>
     <script src="../assets/js/main.js"></script>
    <script>
        // Handle edit class button clicks
        document.querySelectorAll('.edit-class').forEach(button => {
            button.addEventListener('click', function() {
                const modal = new bootstrap.Modal(document.getElementById('editClassModal'));
                document.getElementById('edit_class_id').value = this.dataset.classid;
                document.getElementById('edit_class_name').value = this.dataset.classname;
                document.getElementById('edit_section_id').value = this.dataset.sectionid;
                document.getElementById('edit_max_strength').value = this.dataset.maxstrength;
                modal.show();
            });
        });
    </script>
</body>
</html>